package me.snowdrop.istio.api.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RuleListBuilder extends RuleListFluentImpl<RuleListBuilder> implements VisitableBuilder<RuleList,RuleListBuilder>{

    RuleListFluent<?> fluent;
    Boolean validationEnabled;

    public RuleListBuilder(){
            this(true);
    }
    public RuleListBuilder(Boolean validationEnabled){
            this(new RuleList(), validationEnabled);
    }
    public RuleListBuilder(RuleListFluent<?> fluent){
            this(fluent, true);
    }
    public RuleListBuilder(RuleListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RuleList(), validationEnabled);
    }
    public RuleListBuilder(RuleListFluent<?> fluent,RuleList instance){
            this(fluent, instance, true);
    }
    public RuleListBuilder(RuleListFluent<?> fluent,RuleList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public RuleListBuilder(RuleList instance){
            this(instance,true);
    }
    public RuleListBuilder(RuleList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public RuleList build(){
            RuleList buildable = new RuleList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RuleListBuilder that = (RuleListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
