package me.snowdrop.istio.api.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface RuleListFluent<A extends RuleListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,Rule item);
    public A setToItems(int index,Rule item);
    public A addToItems(Rule... items);
    public A addAllToItems(Collection<Rule> items);
    public A removeFromItems(Rule... items);
    public A removeAllFromItems(Collection<Rule> items);
    public A removeMatchingFromItems(Predicate<RuleBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Rule> getItems();
    public List<Rule> buildItems();
    public Rule buildItem(int index);
    public Rule buildFirstItem();
    public Rule buildLastItem();
    public Rule buildMatchingItem(Predicate<RuleBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<RuleBuilder> predicate);
    public A withItems(List<Rule> items);
    public A withItems(Rule... items);
    public Boolean hasItems();
    public RuleListFluent.ItemsNested<A> addNewItem();
    public RuleListFluent.ItemsNested<A> addNewItemLike(Rule item);
    public RuleListFluent.ItemsNested<A> setNewItemLike(int index,Rule item);
    public RuleListFluent.ItemsNested<A> editItem(int index);
    public RuleListFluent.ItemsNested<A> editFirstItem();
    public RuleListFluent.ItemsNested<A> editLastItem();
    public RuleListFluent.ItemsNested<A> editMatchingItem(Predicate<RuleBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,RuleFluent<RuleListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
