
package me.snowdrop.istio.api.policy.v1beta1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "actions",
    "match",
    "requestHeaderOperations",
    "responseHeaderOperations",
    "sampling"
})
@IstioKind(name = "rule", plural = "rules")
@IstioApiVersion("config.istio.io/v1alpha2")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class RuleSpec implements Serializable, IstioSpec
{

    /**
     * 
     * 
     */
    @JsonProperty("actions")
    @JsonPropertyDescription("")
    private List<Action> actions = new ArrayList<Action>();
    /**
     * 
     * 
     */
    @JsonProperty("match")
    @JsonPropertyDescription("")
    private String match;
    /**
     * 
     * 
     */
    @JsonProperty("requestHeaderOperations")
    @JsonPropertyDescription("")
    private List<HeaderOperationTemplate> requestHeaderOperations = new ArrayList<HeaderOperationTemplate>();
    /**
     * 
     * 
     */
    @JsonProperty("responseHeaderOperations")
    @JsonPropertyDescription("")
    private List<HeaderOperationTemplate> responseHeaderOperations = new ArrayList<HeaderOperationTemplate>();
    /**
     * 
     * 
     */
    @JsonProperty("sampling")
    @JsonPropertyDescription("")
    private Sampling sampling;
    private final static long serialVersionUID = 5980861318940303156L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public RuleSpec() {
    }

    /**
     * 
     * @param requestHeaderOperations
     * @param responseHeaderOperations
     * @param sampling
     * @param match
     * @param actions
     */
    public RuleSpec(List<Action> actions, String match, List<HeaderOperationTemplate> requestHeaderOperations, List<HeaderOperationTemplate> responseHeaderOperations, Sampling sampling) {
        super();
        this.actions = actions;
        this.match = match;
        this.requestHeaderOperations = requestHeaderOperations;
        this.responseHeaderOperations = responseHeaderOperations;
        this.sampling = sampling;
    }

    /**
     * 
     * 
     */
    @JsonProperty("actions")
    public List<Action> getActions() {
        return actions;
    }

    /**
     * 
     * 
     */
    @JsonProperty("actions")
    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    /**
     * 
     * 
     */
    @JsonProperty("match")
    public String getMatch() {
        return match;
    }

    /**
     * 
     * 
     */
    @JsonProperty("match")
    public void setMatch(String match) {
        this.match = match;
    }

    /**
     * 
     * 
     */
    @JsonProperty("requestHeaderOperations")
    public List<HeaderOperationTemplate> getRequestHeaderOperations() {
        return requestHeaderOperations;
    }

    /**
     * 
     * 
     */
    @JsonProperty("requestHeaderOperations")
    public void setRequestHeaderOperations(List<HeaderOperationTemplate> requestHeaderOperations) {
        this.requestHeaderOperations = requestHeaderOperations;
    }

    /**
     * 
     * 
     */
    @JsonProperty("responseHeaderOperations")
    public List<HeaderOperationTemplate> getResponseHeaderOperations() {
        return responseHeaderOperations;
    }

    /**
     * 
     * 
     */
    @JsonProperty("responseHeaderOperations")
    public void setResponseHeaderOperations(List<HeaderOperationTemplate> responseHeaderOperations) {
        this.responseHeaderOperations = responseHeaderOperations;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sampling")
    public Sampling getSampling() {
        return sampling;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sampling")
    public void setSampling(Sampling sampling) {
        this.sampling = sampling;
    }

}
