package me.snowdrop.istio.api.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RuleSpecBuilder extends RuleSpecFluentImpl<RuleSpecBuilder> implements VisitableBuilder<RuleSpec,RuleSpecBuilder>{

    RuleSpecFluent<?> fluent;
    Boolean validationEnabled;

    public RuleSpecBuilder(){
            this(true);
    }
    public RuleSpecBuilder(Boolean validationEnabled){
            this(new RuleSpec(), validationEnabled);
    }
    public RuleSpecBuilder(RuleSpecFluent<?> fluent){
            this(fluent, true);
    }
    public RuleSpecBuilder(RuleSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RuleSpec(), validationEnabled);
    }
    public RuleSpecBuilder(RuleSpecFluent<?> fluent,RuleSpec instance){
            this(fluent, instance, true);
    }
    public RuleSpecBuilder(RuleSpecFluent<?> fluent,RuleSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withActions(instance.getActions()); 
            fluent.withMatch(instance.getMatch()); 
            fluent.withRequestHeaderOperations(instance.getRequestHeaderOperations()); 
            fluent.withResponseHeaderOperations(instance.getResponseHeaderOperations()); 
            fluent.withSampling(instance.getSampling()); 
            this.validationEnabled = validationEnabled; 
    }
    public RuleSpecBuilder(RuleSpec instance){
            this(instance,true);
    }
    public RuleSpecBuilder(RuleSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withActions(instance.getActions()); 
            this.withMatch(instance.getMatch()); 
            this.withRequestHeaderOperations(instance.getRequestHeaderOperations()); 
            this.withResponseHeaderOperations(instance.getResponseHeaderOperations()); 
            this.withSampling(instance.getSampling()); 
            this.validationEnabled = validationEnabled; 
    }

    public RuleSpec build(){
            RuleSpec buildable = new RuleSpec(fluent.getActions(),fluent.getMatch(),fluent.getRequestHeaderOperations(),fluent.getResponseHeaderOperations(),fluent.getSampling());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RuleSpecBuilder that = (RuleSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
