package me.snowdrop.istio.api.policy.v1beta1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class RuleSpecFluentImpl<A extends RuleSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RuleSpecFluent<A>{

    private List<ActionBuilder> actions;
    private String match;
    private List<HeaderOperationTemplateBuilder> requestHeaderOperations;
    private List<HeaderOperationTemplateBuilder> responseHeaderOperations;
    private SamplingBuilder sampling;

    public RuleSpecFluentImpl(){
    }
    public RuleSpecFluentImpl(RuleSpec instance){
            this.withActions(instance.getActions()); 
            this.withMatch(instance.getMatch()); 
            this.withRequestHeaderOperations(instance.getRequestHeaderOperations()); 
            this.withResponseHeaderOperations(instance.getResponseHeaderOperations()); 
            this.withSampling(instance.getSampling()); 
    }

    public A addToActions(int index,Action item){
            if (this.actions == null) {this.actions = new ArrayList<ActionBuilder>();}
            ActionBuilder builder = new ActionBuilder(item);_visitables.get("actions").add(index >= 0 ? index : _visitables.get("actions").size(), builder);this.actions.add(index >= 0 ? index : actions.size(), builder); return (A)this;
    }

    public A setToActions(int index,Action item){
            if (this.actions == null) {this.actions = new ArrayList<ActionBuilder>();}
            ActionBuilder builder = new ActionBuilder(item);
            if (index < 0 || index >= _visitables.get("actions").size()) { _visitables.get("actions").add(builder); } else { _visitables.get("actions").set(index, builder);}
            if (index < 0 || index >= actions.size()) { actions.add(builder); } else { actions.set(index, builder);}
             return (A)this;
    }

    public A addToActions(Action... items){
            if (this.actions == null) {this.actions = new ArrayList<ActionBuilder>();}
            for (Action item : items) {ActionBuilder builder = new ActionBuilder(item);_visitables.get("actions").add(builder);this.actions.add(builder);} return (A)this;
    }

    public A addAllToActions(Collection<Action> items){
            if (this.actions == null) {this.actions = new ArrayList<ActionBuilder>();}
            for (Action item : items) {ActionBuilder builder = new ActionBuilder(item);_visitables.get("actions").add(builder);this.actions.add(builder);} return (A)this;
    }

    public A removeFromActions(Action... items){
            for (Action item : items) {ActionBuilder builder = new ActionBuilder(item);_visitables.get("actions").remove(builder);if (this.actions != null) {this.actions.remove(builder);}} return (A)this;
    }

    public A removeAllFromActions(Collection<Action> items){
            for (Action item : items) {ActionBuilder builder = new ActionBuilder(item);_visitables.get("actions").remove(builder);if (this.actions != null) {this.actions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromActions(io.fabric8.kubernetes.api.builder.Predicate<ActionBuilder> predicate){
            if (actions == null) return (A) this;
            final Iterator<ActionBuilder> each = actions.iterator();
            final List visitables = _visitables.get("actions");
            while (each.hasNext()) {
              ActionBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildActions instead.
 * @return The buildable object.
 */
@Deprecated public List<Action> getActions(){
            return build(actions);
    }

    public List<Action> buildActions(){
            return build(actions);
    }

    public Action buildAction(int index){
            return this.actions.get(index).build();
    }

    public Action buildFirstAction(){
            return this.actions.get(0).build();
    }

    public Action buildLastAction(){
            return this.actions.get(actions.size() - 1).build();
    }

    public Action buildMatchingAction(io.fabric8.kubernetes.api.builder.Predicate<ActionBuilder> predicate){
            for (ActionBuilder item: actions) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingAction(io.fabric8.kubernetes.api.builder.Predicate<ActionBuilder> predicate){
            for (ActionBuilder item: actions) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withActions(List<Action> actions){
            if (this.actions != null) { _visitables.get("actions").removeAll(this.actions);}
            if (actions != null) {this.actions = new ArrayList<ActionBuilder>(); for (Action item : actions){this.addToActions(item);}} else { this.actions = null;} return (A) this;
    }

    public A withActions(Action... actions){
            if (this.actions != null) {this.actions.clear();}
            if (actions != null) {for (Action item :actions){ this.addToActions(item);}} return (A) this;
    }

    public Boolean hasActions(){
            return actions != null && !actions.isEmpty();
    }

    public RuleSpecFluent.ActionsNested<A> addNewAction(){
            return new ActionsNestedImpl();
    }

    public RuleSpecFluent.ActionsNested<A> addNewActionLike(Action item){
            return new ActionsNestedImpl(-1, item);
    }

    public RuleSpecFluent.ActionsNested<A> setNewActionLike(int index,Action item){
            return new ActionsNestedImpl(index, item);
    }

    public RuleSpecFluent.ActionsNested<A> editAction(int index){
            if (actions.size() <= index) throw new RuntimeException("Can't edit actions. Index exceeds size.");
            return setNewActionLike(index, buildAction(index));
    }

    public RuleSpecFluent.ActionsNested<A> editFirstAction(){
            if (actions.size() == 0) throw new RuntimeException("Can't edit first actions. The list is empty.");
            return setNewActionLike(0, buildAction(0));
    }

    public RuleSpecFluent.ActionsNested<A> editLastAction(){
            int index = actions.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last actions. The list is empty.");
            return setNewActionLike(index, buildAction(index));
    }

    public RuleSpecFluent.ActionsNested<A> editMatchingAction(io.fabric8.kubernetes.api.builder.Predicate<ActionBuilder> predicate){
            int index = -1;
            for (int i=0;i<actions.size();i++) { 
            if (predicate.apply(actions.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching actions. No match found.");
            return setNewActionLike(index, buildAction(index));
    }

    public String getMatch(){
            return this.match;
    }

    public A withMatch(String match){
            this.match=match; return (A) this;
    }

    public Boolean hasMatch(){
            return this.match != null;
    }

    public A withNewMatch(String arg1){
            return (A)withMatch(new String(arg1));
    }

    public A withNewMatch(StringBuilder arg1){
            return (A)withMatch(new String(arg1));
    }

    public A withNewMatch(StringBuffer arg1){
            return (A)withMatch(new String(arg1));
    }

    public A addToRequestHeaderOperations(int index,HeaderOperationTemplate item){
            if (this.requestHeaderOperations == null) {this.requestHeaderOperations = new ArrayList<HeaderOperationTemplateBuilder>();}
            HeaderOperationTemplateBuilder builder = new HeaderOperationTemplateBuilder(item);_visitables.get("requestHeaderOperations").add(index >= 0 ? index : _visitables.get("requestHeaderOperations").size(), builder);this.requestHeaderOperations.add(index >= 0 ? index : requestHeaderOperations.size(), builder); return (A)this;
    }

    public A setToRequestHeaderOperations(int index,HeaderOperationTemplate item){
            if (this.requestHeaderOperations == null) {this.requestHeaderOperations = new ArrayList<HeaderOperationTemplateBuilder>();}
            HeaderOperationTemplateBuilder builder = new HeaderOperationTemplateBuilder(item);
            if (index < 0 || index >= _visitables.get("requestHeaderOperations").size()) { _visitables.get("requestHeaderOperations").add(builder); } else { _visitables.get("requestHeaderOperations").set(index, builder);}
            if (index < 0 || index >= requestHeaderOperations.size()) { requestHeaderOperations.add(builder); } else { requestHeaderOperations.set(index, builder);}
             return (A)this;
    }

    public A addToRequestHeaderOperations(HeaderOperationTemplate... items){
            if (this.requestHeaderOperations == null) {this.requestHeaderOperations = new ArrayList<HeaderOperationTemplateBuilder>();}
            for (HeaderOperationTemplate item : items) {HeaderOperationTemplateBuilder builder = new HeaderOperationTemplateBuilder(item);_visitables.get("requestHeaderOperations").add(builder);this.requestHeaderOperations.add(builder);} return (A)this;
    }

    public A addAllToRequestHeaderOperations(Collection<HeaderOperationTemplate> items){
            if (this.requestHeaderOperations == null) {this.requestHeaderOperations = new ArrayList<HeaderOperationTemplateBuilder>();}
            for (HeaderOperationTemplate item : items) {HeaderOperationTemplateBuilder builder = new HeaderOperationTemplateBuilder(item);_visitables.get("requestHeaderOperations").add(builder);this.requestHeaderOperations.add(builder);} return (A)this;
    }

    public A removeFromRequestHeaderOperations(HeaderOperationTemplate... items){
            for (HeaderOperationTemplate item : items) {HeaderOperationTemplateBuilder builder = new HeaderOperationTemplateBuilder(item);_visitables.get("requestHeaderOperations").remove(builder);if (this.requestHeaderOperations != null) {this.requestHeaderOperations.remove(builder);}} return (A)this;
    }

    public A removeAllFromRequestHeaderOperations(Collection<HeaderOperationTemplate> items){
            for (HeaderOperationTemplate item : items) {HeaderOperationTemplateBuilder builder = new HeaderOperationTemplateBuilder(item);_visitables.get("requestHeaderOperations").remove(builder);if (this.requestHeaderOperations != null) {this.requestHeaderOperations.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromRequestHeaderOperations(io.fabric8.kubernetes.api.builder.Predicate<HeaderOperationTemplateBuilder> predicate){
            if (requestHeaderOperations == null) return (A) this;
            final Iterator<HeaderOperationTemplateBuilder> each = requestHeaderOperations.iterator();
            final List visitables = _visitables.get("requestHeaderOperations");
            while (each.hasNext()) {
              HeaderOperationTemplateBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRequestHeaderOperations instead.
 * @return The buildable object.
 */
@Deprecated public List<HeaderOperationTemplate> getRequestHeaderOperations(){
            return build(requestHeaderOperations);
    }

    public List<HeaderOperationTemplate> buildRequestHeaderOperations(){
            return build(requestHeaderOperations);
    }

    public HeaderOperationTemplate buildRequestHeaderOperation(int index){
            return this.requestHeaderOperations.get(index).build();
    }

    public HeaderOperationTemplate buildFirstRequestHeaderOperation(){
            return this.requestHeaderOperations.get(0).build();
    }

    public HeaderOperationTemplate buildLastRequestHeaderOperation(){
            return this.requestHeaderOperations.get(requestHeaderOperations.size() - 1).build();
    }

    public HeaderOperationTemplate buildMatchingRequestHeaderOperation(io.fabric8.kubernetes.api.builder.Predicate<HeaderOperationTemplateBuilder> predicate){
            for (HeaderOperationTemplateBuilder item: requestHeaderOperations) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingRequestHeaderOperation(io.fabric8.kubernetes.api.builder.Predicate<HeaderOperationTemplateBuilder> predicate){
            for (HeaderOperationTemplateBuilder item: requestHeaderOperations) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withRequestHeaderOperations(List<HeaderOperationTemplate> requestHeaderOperations){
            if (this.requestHeaderOperations != null) { _visitables.get("requestHeaderOperations").removeAll(this.requestHeaderOperations);}
            if (requestHeaderOperations != null) {this.requestHeaderOperations = new ArrayList<HeaderOperationTemplateBuilder>(); for (HeaderOperationTemplate item : requestHeaderOperations){this.addToRequestHeaderOperations(item);}} else { this.requestHeaderOperations = null;} return (A) this;
    }

    public A withRequestHeaderOperations(HeaderOperationTemplate... requestHeaderOperations){
            if (this.requestHeaderOperations != null) {this.requestHeaderOperations.clear();}
            if (requestHeaderOperations != null) {for (HeaderOperationTemplate item :requestHeaderOperations){ this.addToRequestHeaderOperations(item);}} return (A) this;
    }

    public Boolean hasRequestHeaderOperations(){
            return requestHeaderOperations != null && !requestHeaderOperations.isEmpty();
    }

    public RuleSpecFluent.RequestHeaderOperationsNested<A> addNewRequestHeaderOperation(){
            return new RequestHeaderOperationsNestedImpl();
    }

    public RuleSpecFluent.RequestHeaderOperationsNested<A> addNewRequestHeaderOperationLike(HeaderOperationTemplate item){
            return new RequestHeaderOperationsNestedImpl(-1, item);
    }

    public RuleSpecFluent.RequestHeaderOperationsNested<A> setNewRequestHeaderOperationLike(int index,HeaderOperationTemplate item){
            return new RequestHeaderOperationsNestedImpl(index, item);
    }

    public RuleSpecFluent.RequestHeaderOperationsNested<A> editRequestHeaderOperation(int index){
            if (requestHeaderOperations.size() <= index) throw new RuntimeException("Can't edit requestHeaderOperations. Index exceeds size.");
            return setNewRequestHeaderOperationLike(index, buildRequestHeaderOperation(index));
    }

    public RuleSpecFluent.RequestHeaderOperationsNested<A> editFirstRequestHeaderOperation(){
            if (requestHeaderOperations.size() == 0) throw new RuntimeException("Can't edit first requestHeaderOperations. The list is empty.");
            return setNewRequestHeaderOperationLike(0, buildRequestHeaderOperation(0));
    }

    public RuleSpecFluent.RequestHeaderOperationsNested<A> editLastRequestHeaderOperation(){
            int index = requestHeaderOperations.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last requestHeaderOperations. The list is empty.");
            return setNewRequestHeaderOperationLike(index, buildRequestHeaderOperation(index));
    }

    public RuleSpecFluent.RequestHeaderOperationsNested<A> editMatchingRequestHeaderOperation(io.fabric8.kubernetes.api.builder.Predicate<HeaderOperationTemplateBuilder> predicate){
            int index = -1;
            for (int i=0;i<requestHeaderOperations.size();i++) { 
            if (predicate.apply(requestHeaderOperations.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching requestHeaderOperations. No match found.");
            return setNewRequestHeaderOperationLike(index, buildRequestHeaderOperation(index));
    }

    public A addToResponseHeaderOperations(int index,HeaderOperationTemplate item){
            if (this.responseHeaderOperations == null) {this.responseHeaderOperations = new ArrayList<HeaderOperationTemplateBuilder>();}
            HeaderOperationTemplateBuilder builder = new HeaderOperationTemplateBuilder(item);_visitables.get("responseHeaderOperations").add(index >= 0 ? index : _visitables.get("responseHeaderOperations").size(), builder);this.responseHeaderOperations.add(index >= 0 ? index : responseHeaderOperations.size(), builder); return (A)this;
    }

    public A setToResponseHeaderOperations(int index,HeaderOperationTemplate item){
            if (this.responseHeaderOperations == null) {this.responseHeaderOperations = new ArrayList<HeaderOperationTemplateBuilder>();}
            HeaderOperationTemplateBuilder builder = new HeaderOperationTemplateBuilder(item);
            if (index < 0 || index >= _visitables.get("responseHeaderOperations").size()) { _visitables.get("responseHeaderOperations").add(builder); } else { _visitables.get("responseHeaderOperations").set(index, builder);}
            if (index < 0 || index >= responseHeaderOperations.size()) { responseHeaderOperations.add(builder); } else { responseHeaderOperations.set(index, builder);}
             return (A)this;
    }

    public A addToResponseHeaderOperations(HeaderOperationTemplate... items){
            if (this.responseHeaderOperations == null) {this.responseHeaderOperations = new ArrayList<HeaderOperationTemplateBuilder>();}
            for (HeaderOperationTemplate item : items) {HeaderOperationTemplateBuilder builder = new HeaderOperationTemplateBuilder(item);_visitables.get("responseHeaderOperations").add(builder);this.responseHeaderOperations.add(builder);} return (A)this;
    }

    public A addAllToResponseHeaderOperations(Collection<HeaderOperationTemplate> items){
            if (this.responseHeaderOperations == null) {this.responseHeaderOperations = new ArrayList<HeaderOperationTemplateBuilder>();}
            for (HeaderOperationTemplate item : items) {HeaderOperationTemplateBuilder builder = new HeaderOperationTemplateBuilder(item);_visitables.get("responseHeaderOperations").add(builder);this.responseHeaderOperations.add(builder);} return (A)this;
    }

    public A removeFromResponseHeaderOperations(HeaderOperationTemplate... items){
            for (HeaderOperationTemplate item : items) {HeaderOperationTemplateBuilder builder = new HeaderOperationTemplateBuilder(item);_visitables.get("responseHeaderOperations").remove(builder);if (this.responseHeaderOperations != null) {this.responseHeaderOperations.remove(builder);}} return (A)this;
    }

    public A removeAllFromResponseHeaderOperations(Collection<HeaderOperationTemplate> items){
            for (HeaderOperationTemplate item : items) {HeaderOperationTemplateBuilder builder = new HeaderOperationTemplateBuilder(item);_visitables.get("responseHeaderOperations").remove(builder);if (this.responseHeaderOperations != null) {this.responseHeaderOperations.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromResponseHeaderOperations(io.fabric8.kubernetes.api.builder.Predicate<HeaderOperationTemplateBuilder> predicate){
            if (responseHeaderOperations == null) return (A) this;
            final Iterator<HeaderOperationTemplateBuilder> each = responseHeaderOperations.iterator();
            final List visitables = _visitables.get("responseHeaderOperations");
            while (each.hasNext()) {
              HeaderOperationTemplateBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildResponseHeaderOperations instead.
 * @return The buildable object.
 */
@Deprecated public List<HeaderOperationTemplate> getResponseHeaderOperations(){
            return build(responseHeaderOperations);
    }

    public List<HeaderOperationTemplate> buildResponseHeaderOperations(){
            return build(responseHeaderOperations);
    }

    public HeaderOperationTemplate buildResponseHeaderOperation(int index){
            return this.responseHeaderOperations.get(index).build();
    }

    public HeaderOperationTemplate buildFirstResponseHeaderOperation(){
            return this.responseHeaderOperations.get(0).build();
    }

    public HeaderOperationTemplate buildLastResponseHeaderOperation(){
            return this.responseHeaderOperations.get(responseHeaderOperations.size() - 1).build();
    }

    public HeaderOperationTemplate buildMatchingResponseHeaderOperation(io.fabric8.kubernetes.api.builder.Predicate<HeaderOperationTemplateBuilder> predicate){
            for (HeaderOperationTemplateBuilder item: responseHeaderOperations) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingResponseHeaderOperation(io.fabric8.kubernetes.api.builder.Predicate<HeaderOperationTemplateBuilder> predicate){
            for (HeaderOperationTemplateBuilder item: responseHeaderOperations) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withResponseHeaderOperations(List<HeaderOperationTemplate> responseHeaderOperations){
            if (this.responseHeaderOperations != null) { _visitables.get("responseHeaderOperations").removeAll(this.responseHeaderOperations);}
            if (responseHeaderOperations != null) {this.responseHeaderOperations = new ArrayList<HeaderOperationTemplateBuilder>(); for (HeaderOperationTemplate item : responseHeaderOperations){this.addToResponseHeaderOperations(item);}} else { this.responseHeaderOperations = null;} return (A) this;
    }

    public A withResponseHeaderOperations(HeaderOperationTemplate... responseHeaderOperations){
            if (this.responseHeaderOperations != null) {this.responseHeaderOperations.clear();}
            if (responseHeaderOperations != null) {for (HeaderOperationTemplate item :responseHeaderOperations){ this.addToResponseHeaderOperations(item);}} return (A) this;
    }

    public Boolean hasResponseHeaderOperations(){
            return responseHeaderOperations != null && !responseHeaderOperations.isEmpty();
    }

    public RuleSpecFluent.ResponseHeaderOperationsNested<A> addNewResponseHeaderOperation(){
            return new ResponseHeaderOperationsNestedImpl();
    }

    public RuleSpecFluent.ResponseHeaderOperationsNested<A> addNewResponseHeaderOperationLike(HeaderOperationTemplate item){
            return new ResponseHeaderOperationsNestedImpl(-1, item);
    }

    public RuleSpecFluent.ResponseHeaderOperationsNested<A> setNewResponseHeaderOperationLike(int index,HeaderOperationTemplate item){
            return new ResponseHeaderOperationsNestedImpl(index, item);
    }

    public RuleSpecFluent.ResponseHeaderOperationsNested<A> editResponseHeaderOperation(int index){
            if (responseHeaderOperations.size() <= index) throw new RuntimeException("Can't edit responseHeaderOperations. Index exceeds size.");
            return setNewResponseHeaderOperationLike(index, buildResponseHeaderOperation(index));
    }

    public RuleSpecFluent.ResponseHeaderOperationsNested<A> editFirstResponseHeaderOperation(){
            if (responseHeaderOperations.size() == 0) throw new RuntimeException("Can't edit first responseHeaderOperations. The list is empty.");
            return setNewResponseHeaderOperationLike(0, buildResponseHeaderOperation(0));
    }

    public RuleSpecFluent.ResponseHeaderOperationsNested<A> editLastResponseHeaderOperation(){
            int index = responseHeaderOperations.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last responseHeaderOperations. The list is empty.");
            return setNewResponseHeaderOperationLike(index, buildResponseHeaderOperation(index));
    }

    public RuleSpecFluent.ResponseHeaderOperationsNested<A> editMatchingResponseHeaderOperation(io.fabric8.kubernetes.api.builder.Predicate<HeaderOperationTemplateBuilder> predicate){
            int index = -1;
            for (int i=0;i<responseHeaderOperations.size();i++) { 
            if (predicate.apply(responseHeaderOperations.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching responseHeaderOperations. No match found.");
            return setNewResponseHeaderOperationLike(index, buildResponseHeaderOperation(index));
    }

    
/**
 * This method has been deprecated, please use method buildSampling instead.
 * @return The buildable object.
 */
@Deprecated public Sampling getSampling(){
            return this.sampling!=null?this.sampling.build():null;
    }

    public Sampling buildSampling(){
            return this.sampling!=null?this.sampling.build():null;
    }

    public A withSampling(Sampling sampling){
            _visitables.get("sampling").remove(this.sampling);
            if (sampling!=null){ this.sampling= new SamplingBuilder(sampling); _visitables.get("sampling").add(this.sampling);} return (A) this;
    }

    public Boolean hasSampling(){
            return this.sampling != null;
    }

    public RuleSpecFluent.SamplingNested<A> withNewSampling(){
            return new SamplingNestedImpl();
    }

    public RuleSpecFluent.SamplingNested<A> withNewSamplingLike(Sampling item){
            return new SamplingNestedImpl(item);
    }

    public RuleSpecFluent.SamplingNested<A> editSampling(){
            return withNewSamplingLike(getSampling());
    }

    public RuleSpecFluent.SamplingNested<A> editOrNewSampling(){
            return withNewSamplingLike(getSampling() != null ? getSampling(): new SamplingBuilder().build());
    }

    public RuleSpecFluent.SamplingNested<A> editOrNewSamplingLike(Sampling item){
            return withNewSamplingLike(getSampling() != null ? getSampling(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            RuleSpecFluentImpl that = (RuleSpecFluentImpl) o;
            if (actions != null ? !actions.equals(that.actions) :that.actions != null) return false;
            if (match != null ? !match.equals(that.match) :that.match != null) return false;
            if (requestHeaderOperations != null ? !requestHeaderOperations.equals(that.requestHeaderOperations) :that.requestHeaderOperations != null) return false;
            if (responseHeaderOperations != null ? !responseHeaderOperations.equals(that.responseHeaderOperations) :that.responseHeaderOperations != null) return false;
            if (sampling != null ? !sampling.equals(that.sampling) :that.sampling != null) return false;
            return true;
    }


    public class ActionsNestedImpl<N> extends ActionFluentImpl<RuleSpecFluent.ActionsNested<N>> implements RuleSpecFluent.ActionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ActionBuilder builder;
        private final int index;
    
            ActionsNestedImpl(int index,Action item){
                    this.index = index;
                    this.builder = new ActionBuilder(this, item);
            }
            ActionsNestedImpl(){
                    this.index = -1;
                    this.builder = new ActionBuilder(this);
            }
    
    public N and(){
            return (N) RuleSpecFluentImpl.this.setToActions(index, builder.build());
    }
    public N endAction(){
            return and();
    }

}
    public class RequestHeaderOperationsNestedImpl<N> extends HeaderOperationTemplateFluentImpl<RuleSpecFluent.RequestHeaderOperationsNested<N>> implements RuleSpecFluent.RequestHeaderOperationsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final HeaderOperationTemplateBuilder builder;
        private final int index;
    
            RequestHeaderOperationsNestedImpl(int index,HeaderOperationTemplate item){
                    this.index = index;
                    this.builder = new HeaderOperationTemplateBuilder(this, item);
            }
            RequestHeaderOperationsNestedImpl(){
                    this.index = -1;
                    this.builder = new HeaderOperationTemplateBuilder(this);
            }
    
    public N and(){
            return (N) RuleSpecFluentImpl.this.setToRequestHeaderOperations(index, builder.build());
    }
    public N endRequestHeaderOperation(){
            return and();
    }

}
    public class ResponseHeaderOperationsNestedImpl<N> extends HeaderOperationTemplateFluentImpl<RuleSpecFluent.ResponseHeaderOperationsNested<N>> implements RuleSpecFluent.ResponseHeaderOperationsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final HeaderOperationTemplateBuilder builder;
        private final int index;
    
            ResponseHeaderOperationsNestedImpl(int index,HeaderOperationTemplate item){
                    this.index = index;
                    this.builder = new HeaderOperationTemplateBuilder(this, item);
            }
            ResponseHeaderOperationsNestedImpl(){
                    this.index = -1;
                    this.builder = new HeaderOperationTemplateBuilder(this);
            }
    
    public N and(){
            return (N) RuleSpecFluentImpl.this.setToResponseHeaderOperations(index, builder.build());
    }
    public N endResponseHeaderOperation(){
            return and();
    }

}
    public class SamplingNestedImpl<N> extends SamplingFluentImpl<RuleSpecFluent.SamplingNested<N>> implements RuleSpecFluent.SamplingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SamplingBuilder builder;
    
            SamplingNestedImpl(Sampling item){
                    this.builder = new SamplingBuilder(this, item);
            }
            SamplingNestedImpl(){
                    this.builder = new SamplingBuilder(this);
            }
    
    public N and(){
            return (N) RuleSpecFluentImpl.this.withSampling(builder.build());
    }
    public N endSampling(){
            return and();
    }

}


}
