
package me.snowdrop.istio.api.policy.v1beta1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "random",
    "rateLimit"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Sampling implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("random")
    @JsonPropertyDescription("")
    private RandomSampling random;
    /**
     * 
     * 
     */
    @JsonProperty("rateLimit")
    @JsonPropertyDescription("")
    private RateLimitSampling rateLimit;
    private final static long serialVersionUID = -7115897983965392194L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Sampling() {
    }

    /**
     * 
     * @param random
     * @param rateLimit
     */
    public Sampling(RandomSampling random, RateLimitSampling rateLimit) {
        super();
        this.random = random;
        this.rateLimit = rateLimit;
    }

    /**
     * 
     * 
     */
    @JsonProperty("random")
    public RandomSampling getRandom() {
        return random;
    }

    /**
     * 
     * 
     */
    @JsonProperty("random")
    public void setRandom(RandomSampling random) {
        this.random = random;
    }

    /**
     * 
     * 
     */
    @JsonProperty("rateLimit")
    public RateLimitSampling getRateLimit() {
        return rateLimit;
    }

    /**
     * 
     * 
     */
    @JsonProperty("rateLimit")
    public void setRateLimit(RateLimitSampling rateLimit) {
        this.rateLimit = rateLimit;
    }

}
