package me.snowdrop.istio.api.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SamplingBuilder extends SamplingFluentImpl<SamplingBuilder> implements VisitableBuilder<Sampling,SamplingBuilder>{

    SamplingFluent<?> fluent;
    Boolean validationEnabled;

    public SamplingBuilder(){
            this(true);
    }
    public SamplingBuilder(Boolean validationEnabled){
            this(new Sampling(), validationEnabled);
    }
    public SamplingBuilder(SamplingFluent<?> fluent){
            this(fluent, true);
    }
    public SamplingBuilder(SamplingFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Sampling(), validationEnabled);
    }
    public SamplingBuilder(SamplingFluent<?> fluent,Sampling instance){
            this(fluent, instance, true);
    }
    public SamplingBuilder(SamplingFluent<?> fluent,Sampling instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withRandom(instance.getRandom()); 
            fluent.withRateLimit(instance.getRateLimit()); 
            this.validationEnabled = validationEnabled; 
    }
    public SamplingBuilder(Sampling instance){
            this(instance,true);
    }
    public SamplingBuilder(Sampling instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withRandom(instance.getRandom()); 
            this.withRateLimit(instance.getRateLimit()); 
            this.validationEnabled = validationEnabled; 
    }

    public Sampling build(){
            Sampling buildable = new Sampling(fluent.getRandom(),fluent.getRateLimit());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SamplingBuilder that = (SamplingBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
