package me.snowdrop.istio.api.policy.v1beta1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class SamplingFluentImpl<A extends SamplingFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SamplingFluent<A>{

    private RandomSamplingBuilder random;
    private RateLimitSamplingBuilder rateLimit;

    public SamplingFluentImpl(){
    }
    public SamplingFluentImpl(Sampling instance){
            this.withRandom(instance.getRandom()); 
            this.withRateLimit(instance.getRateLimit()); 
    }

    
/**
 * This method has been deprecated, please use method buildRandom instead.
 * @return The buildable object.
 */
@Deprecated public RandomSampling getRandom(){
            return this.random!=null?this.random.build():null;
    }

    public RandomSampling buildRandom(){
            return this.random!=null?this.random.build():null;
    }

    public A withRandom(RandomSampling random){
            _visitables.get("random").remove(this.random);
            if (random!=null){ this.random= new RandomSamplingBuilder(random); _visitables.get("random").add(this.random);} return (A) this;
    }

    public Boolean hasRandom(){
            return this.random != null;
    }

    public SamplingFluent.RandomNested<A> withNewRandom(){
            return new RandomNestedImpl();
    }

    public SamplingFluent.RandomNested<A> withNewRandomLike(RandomSampling item){
            return new RandomNestedImpl(item);
    }

    public SamplingFluent.RandomNested<A> editRandom(){
            return withNewRandomLike(getRandom());
    }

    public SamplingFluent.RandomNested<A> editOrNewRandom(){
            return withNewRandomLike(getRandom() != null ? getRandom(): new RandomSamplingBuilder().build());
    }

    public SamplingFluent.RandomNested<A> editOrNewRandomLike(RandomSampling item){
            return withNewRandomLike(getRandom() != null ? getRandom(): item);
    }

    
/**
 * This method has been deprecated, please use method buildRateLimit instead.
 * @return The buildable object.
 */
@Deprecated public RateLimitSampling getRateLimit(){
            return this.rateLimit!=null?this.rateLimit.build():null;
    }

    public RateLimitSampling buildRateLimit(){
            return this.rateLimit!=null?this.rateLimit.build():null;
    }

    public A withRateLimit(RateLimitSampling rateLimit){
            _visitables.get("rateLimit").remove(this.rateLimit);
            if (rateLimit!=null){ this.rateLimit= new RateLimitSamplingBuilder(rateLimit); _visitables.get("rateLimit").add(this.rateLimit);} return (A) this;
    }

    public Boolean hasRateLimit(){
            return this.rateLimit != null;
    }

    public A withNewRateLimit(Integer maxUnsampledEntries,Integer samplingDuration,Integer samplingRate){
            return (A)withRateLimit(new RateLimitSampling(maxUnsampledEntries, samplingDuration, samplingRate));
    }

    public SamplingFluent.RateLimitNested<A> withNewRateLimit(){
            return new RateLimitNestedImpl();
    }

    public SamplingFluent.RateLimitNested<A> withNewRateLimitLike(RateLimitSampling item){
            return new RateLimitNestedImpl(item);
    }

    public SamplingFluent.RateLimitNested<A> editRateLimit(){
            return withNewRateLimitLike(getRateLimit());
    }

    public SamplingFluent.RateLimitNested<A> editOrNewRateLimit(){
            return withNewRateLimitLike(getRateLimit() != null ? getRateLimit(): new RateLimitSamplingBuilder().build());
    }

    public SamplingFluent.RateLimitNested<A> editOrNewRateLimitLike(RateLimitSampling item){
            return withNewRateLimitLike(getRateLimit() != null ? getRateLimit(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            SamplingFluentImpl that = (SamplingFluentImpl) o;
            if (random != null ? !random.equals(that.random) :that.random != null) return false;
            if (rateLimit != null ? !rateLimit.equals(that.rateLimit) :that.rateLimit != null) return false;
            return true;
    }


    public class RandomNestedImpl<N> extends RandomSamplingFluentImpl<SamplingFluent.RandomNested<N>> implements SamplingFluent.RandomNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RandomSamplingBuilder builder;
    
            RandomNestedImpl(RandomSampling item){
                    this.builder = new RandomSamplingBuilder(this, item);
            }
            RandomNestedImpl(){
                    this.builder = new RandomSamplingBuilder(this);
            }
    
    public N and(){
            return (N) SamplingFluentImpl.this.withRandom(builder.build());
    }
    public N endRandom(){
            return and();
    }

}
    public class RateLimitNestedImpl<N> extends RateLimitSamplingFluentImpl<SamplingFluent.RateLimitNested<N>> implements SamplingFluent.RateLimitNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RateLimitSamplingBuilder builder;
    
            RateLimitNestedImpl(RateLimitSampling item){
                    this.builder = new RateLimitSamplingBuilder(this, item);
            }
            RateLimitNestedImpl(){
                    this.builder = new RateLimitSamplingBuilder(this);
            }
    
    public N and(){
            return (N) SamplingFluentImpl.this.withRateLimit(builder.build());
    }
    public N endRateLimit(){
            return and();
    }

}


}
