
package me.snowdrop.istio.api.rbac.v1alpha1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "constraints",
    "hosts",
    "methods",
    "notHosts",
    "notMethods",
    "notPaths",
    "notPorts",
    "paths",
    "ports",
    "services"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class AccessRule implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("constraints")
    @JsonPropertyDescription("")
    private List<Constraint> constraints = new ArrayList<Constraint>();
    /**
     * 
     * 
     */
    @JsonProperty("hosts")
    @JsonPropertyDescription("")
    private List<String> hosts = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("methods")
    @JsonPropertyDescription("")
    private List<String> methods = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("notHosts")
    @JsonPropertyDescription("")
    private List<String> notHosts = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("notMethods")
    @JsonPropertyDescription("")
    private List<String> notMethods = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("notPaths")
    @JsonPropertyDescription("")
    private List<String> notPaths = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("notPorts")
    @JsonPropertyDescription("")
    private String notPorts;
    /**
     * 
     * 
     */
    @JsonProperty("paths")
    @JsonPropertyDescription("")
    private List<String> paths = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("ports")
    @JsonPropertyDescription("")
    private String ports;
    /**
     * 
     * 
     */
    @JsonProperty("services")
    @JsonPropertyDescription("")
    private List<String> services = new ArrayList<String>();
    private final static long serialVersionUID = -7376884111738322874L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public AccessRule() {
    }

    /**
     * 
     * @param notMethods
     * @param hosts
     * @param methods
     * @param paths
     * @param notPaths
     * @param notHosts
     * @param services
     * @param ports
     * @param constraints
     * @param notPorts
     */
    public AccessRule(List<Constraint> constraints, List<String> hosts, List<String> methods, List<String> notHosts, List<String> notMethods, List<String> notPaths, String notPorts, List<String> paths, String ports, List<String> services) {
        super();
        this.constraints = constraints;
        this.hosts = hosts;
        this.methods = methods;
        this.notHosts = notHosts;
        this.notMethods = notMethods;
        this.notPaths = notPaths;
        this.notPorts = notPorts;
        this.paths = paths;
        this.ports = ports;
        this.services = services;
    }

    /**
     * 
     * 
     */
    @JsonProperty("constraints")
    public List<Constraint> getConstraints() {
        return constraints;
    }

    /**
     * 
     * 
     */
    @JsonProperty("constraints")
    public void setConstraints(List<Constraint> constraints) {
        this.constraints = constraints;
    }

    /**
     * 
     * 
     */
    @JsonProperty("hosts")
    public List<String> getHosts() {
        return hosts;
    }

    /**
     * 
     * 
     */
    @JsonProperty("hosts")
    public void setHosts(List<String> hosts) {
        this.hosts = hosts;
    }

    /**
     * 
     * 
     */
    @JsonProperty("methods")
    public List<String> getMethods() {
        return methods;
    }

    /**
     * 
     * 
     */
    @JsonProperty("methods")
    public void setMethods(List<String> methods) {
        this.methods = methods;
    }

    /**
     * 
     * 
     */
    @JsonProperty("notHosts")
    public List<String> getNotHosts() {
        return notHosts;
    }

    /**
     * 
     * 
     */
    @JsonProperty("notHosts")
    public void setNotHosts(List<String> notHosts) {
        this.notHosts = notHosts;
    }

    /**
     * 
     * 
     */
    @JsonProperty("notMethods")
    public List<String> getNotMethods() {
        return notMethods;
    }

    /**
     * 
     * 
     */
    @JsonProperty("notMethods")
    public void setNotMethods(List<String> notMethods) {
        this.notMethods = notMethods;
    }

    /**
     * 
     * 
     */
    @JsonProperty("notPaths")
    public List<String> getNotPaths() {
        return notPaths;
    }

    /**
     * 
     * 
     */
    @JsonProperty("notPaths")
    public void setNotPaths(List<String> notPaths) {
        this.notPaths = notPaths;
    }

    /**
     * 
     * 
     */
    @JsonProperty("notPorts")
    public String getNotPorts() {
        return notPorts;
    }

    /**
     * 
     * 
     */
    @JsonProperty("notPorts")
    public void setNotPorts(String notPorts) {
        this.notPorts = notPorts;
    }

    /**
     * 
     * 
     */
    @JsonProperty("paths")
    public List<String> getPaths() {
        return paths;
    }

    /**
     * 
     * 
     */
    @JsonProperty("paths")
    public void setPaths(List<String> paths) {
        this.paths = paths;
    }

    /**
     * 
     * 
     */
    @JsonProperty("ports")
    public String getPorts() {
        return ports;
    }

    /**
     * 
     * 
     */
    @JsonProperty("ports")
    public void setPorts(String ports) {
        this.ports = ports;
    }

    /**
     * 
     * 
     */
    @JsonProperty("services")
    public List<String> getServices() {
        return services;
    }

    /**
     * 
     * 
     */
    @JsonProperty("services")
    public void setServices(List<String> services) {
        this.services = services;
    }

}
