package me.snowdrop.istio.api.rbac.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AccessRuleBuilder extends AccessRuleFluentImpl<AccessRuleBuilder> implements VisitableBuilder<AccessRule,AccessRuleBuilder>{

    AccessRuleFluent<?> fluent;
    Boolean validationEnabled;

    public AccessRuleBuilder(){
            this(true);
    }
    public AccessRuleBuilder(Boolean validationEnabled){
            this(new AccessRule(), validationEnabled);
    }
    public AccessRuleBuilder(AccessRuleFluent<?> fluent){
            this(fluent, true);
    }
    public AccessRuleBuilder(AccessRuleFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new AccessRule(), validationEnabled);
    }
    public AccessRuleBuilder(AccessRuleFluent<?> fluent,AccessRule instance){
            this(fluent, instance, true);
    }
    public AccessRuleBuilder(AccessRuleFluent<?> fluent,AccessRule instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConstraints(instance.getConstraints()); 
            fluent.withHosts(instance.getHosts()); 
            fluent.withMethods(instance.getMethods()); 
            fluent.withNotHosts(instance.getNotHosts()); 
            fluent.withNotMethods(instance.getNotMethods()); 
            fluent.withNotPaths(instance.getNotPaths()); 
            fluent.withNotPorts(instance.getNotPorts()); 
            fluent.withPaths(instance.getPaths()); 
            fluent.withPorts(instance.getPorts()); 
            fluent.withServices(instance.getServices()); 
            this.validationEnabled = validationEnabled; 
    }
    public AccessRuleBuilder(AccessRule instance){
            this(instance,true);
    }
    public AccessRuleBuilder(AccessRule instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConstraints(instance.getConstraints()); 
            this.withHosts(instance.getHosts()); 
            this.withMethods(instance.getMethods()); 
            this.withNotHosts(instance.getNotHosts()); 
            this.withNotMethods(instance.getNotMethods()); 
            this.withNotPaths(instance.getNotPaths()); 
            this.withNotPorts(instance.getNotPorts()); 
            this.withPaths(instance.getPaths()); 
            this.withPorts(instance.getPorts()); 
            this.withServices(instance.getServices()); 
            this.validationEnabled = validationEnabled; 
    }

    public AccessRule build(){
            AccessRule buildable = new AccessRule(fluent.getConstraints(),fluent.getHosts(),fluent.getMethods(),fluent.getNotHosts(),fluent.getNotMethods(),fluent.getNotPaths(),fluent.getNotPorts(),fluent.getPaths(),fluent.getPorts(),fluent.getServices());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AccessRuleBuilder that = (AccessRuleBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
