package me.snowdrop.istio.api.rbac.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class AccessRuleFluentImpl<A extends AccessRuleFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements AccessRuleFluent<A>{

    private List<ConstraintBuilder> constraints;
    private List<String> hosts;
    private List<String> methods;
    private List<String> notHosts;
    private List<String> notMethods;
    private List<String> notPaths;
    private String notPorts;
    private List<String> paths;
    private String ports;
    private List<String> services;

    public AccessRuleFluentImpl(){
    }
    public AccessRuleFluentImpl(AccessRule instance){
            this.withConstraints(instance.getConstraints()); 
            this.withHosts(instance.getHosts()); 
            this.withMethods(instance.getMethods()); 
            this.withNotHosts(instance.getNotHosts()); 
            this.withNotMethods(instance.getNotMethods()); 
            this.withNotPaths(instance.getNotPaths()); 
            this.withNotPorts(instance.getNotPorts()); 
            this.withPaths(instance.getPaths()); 
            this.withPorts(instance.getPorts()); 
            this.withServices(instance.getServices()); 
    }

    public A addToConstraints(int index,Constraint item){
            if (this.constraints == null) {this.constraints = new ArrayList<ConstraintBuilder>();}
            ConstraintBuilder builder = new ConstraintBuilder(item);_visitables.get("constraints").add(index >= 0 ? index : _visitables.get("constraints").size(), builder);this.constraints.add(index >= 0 ? index : constraints.size(), builder); return (A)this;
    }

    public A setToConstraints(int index,Constraint item){
            if (this.constraints == null) {this.constraints = new ArrayList<ConstraintBuilder>();}
            ConstraintBuilder builder = new ConstraintBuilder(item);
            if (index < 0 || index >= _visitables.get("constraints").size()) { _visitables.get("constraints").add(builder); } else { _visitables.get("constraints").set(index, builder);}
            if (index < 0 || index >= constraints.size()) { constraints.add(builder); } else { constraints.set(index, builder);}
             return (A)this;
    }

    public A addToConstraints(Constraint... items){
            if (this.constraints == null) {this.constraints = new ArrayList<ConstraintBuilder>();}
            for (Constraint item : items) {ConstraintBuilder builder = new ConstraintBuilder(item);_visitables.get("constraints").add(builder);this.constraints.add(builder);} return (A)this;
    }

    public A addAllToConstraints(Collection<Constraint> items){
            if (this.constraints == null) {this.constraints = new ArrayList<ConstraintBuilder>();}
            for (Constraint item : items) {ConstraintBuilder builder = new ConstraintBuilder(item);_visitables.get("constraints").add(builder);this.constraints.add(builder);} return (A)this;
    }

    public A removeFromConstraints(Constraint... items){
            for (Constraint item : items) {ConstraintBuilder builder = new ConstraintBuilder(item);_visitables.get("constraints").remove(builder);if (this.constraints != null) {this.constraints.remove(builder);}} return (A)this;
    }

    public A removeAllFromConstraints(Collection<Constraint> items){
            for (Constraint item : items) {ConstraintBuilder builder = new ConstraintBuilder(item);_visitables.get("constraints").remove(builder);if (this.constraints != null) {this.constraints.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConstraints(io.fabric8.kubernetes.api.builder.Predicate<ConstraintBuilder> predicate){
            if (constraints == null) return (A) this;
            final Iterator<ConstraintBuilder> each = constraints.iterator();
            final List visitables = _visitables.get("constraints");
            while (each.hasNext()) {
              ConstraintBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConstraints instead.
 * @return The buildable object.
 */
@Deprecated public List<Constraint> getConstraints(){
            return build(constraints);
    }

    public List<Constraint> buildConstraints(){
            return build(constraints);
    }

    public Constraint buildConstraint(int index){
            return this.constraints.get(index).build();
    }

    public Constraint buildFirstConstraint(){
            return this.constraints.get(0).build();
    }

    public Constraint buildLastConstraint(){
            return this.constraints.get(constraints.size() - 1).build();
    }

    public Constraint buildMatchingConstraint(io.fabric8.kubernetes.api.builder.Predicate<ConstraintBuilder> predicate){
            for (ConstraintBuilder item: constraints) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingConstraint(io.fabric8.kubernetes.api.builder.Predicate<ConstraintBuilder> predicate){
            for (ConstraintBuilder item: constraints) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withConstraints(List<Constraint> constraints){
            if (this.constraints != null) { _visitables.get("constraints").removeAll(this.constraints);}
            if (constraints != null) {this.constraints = new ArrayList<ConstraintBuilder>(); for (Constraint item : constraints){this.addToConstraints(item);}} else { this.constraints = null;} return (A) this;
    }

    public A withConstraints(Constraint... constraints){
            if (this.constraints != null) {this.constraints.clear();}
            if (constraints != null) {for (Constraint item :constraints){ this.addToConstraints(item);}} return (A) this;
    }

    public Boolean hasConstraints(){
            return constraints != null && !constraints.isEmpty();
    }

    public AccessRuleFluent.ConstraintsNested<A> addNewConstraint(){
            return new ConstraintsNestedImpl();
    }

    public AccessRuleFluent.ConstraintsNested<A> addNewConstraintLike(Constraint item){
            return new ConstraintsNestedImpl(-1, item);
    }

    public AccessRuleFluent.ConstraintsNested<A> setNewConstraintLike(int index,Constraint item){
            return new ConstraintsNestedImpl(index, item);
    }

    public AccessRuleFluent.ConstraintsNested<A> editConstraint(int index){
            if (constraints.size() <= index) throw new RuntimeException("Can't edit constraints. Index exceeds size.");
            return setNewConstraintLike(index, buildConstraint(index));
    }

    public AccessRuleFluent.ConstraintsNested<A> editFirstConstraint(){
            if (constraints.size() == 0) throw new RuntimeException("Can't edit first constraints. The list is empty.");
            return setNewConstraintLike(0, buildConstraint(0));
    }

    public AccessRuleFluent.ConstraintsNested<A> editLastConstraint(){
            int index = constraints.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last constraints. The list is empty.");
            return setNewConstraintLike(index, buildConstraint(index));
    }

    public AccessRuleFluent.ConstraintsNested<A> editMatchingConstraint(io.fabric8.kubernetes.api.builder.Predicate<ConstraintBuilder> predicate){
            int index = -1;
            for (int i=0;i<constraints.size();i++) { 
            if (predicate.apply(constraints.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching constraints. No match found.");
            return setNewConstraintLike(index, buildConstraint(index));
    }

    public A addToHosts(int index,String item){
            if (this.hosts == null) {this.hosts = new ArrayList<String>();}
            this.hosts.add(index, item);
            return (A)this;
    }

    public A setToHosts(int index,String item){
            if (this.hosts == null) {this.hosts = new ArrayList<String>();}
            this.hosts.set(index, item); return (A)this;
    }

    public A addToHosts(String... items){
            if (this.hosts == null) {this.hosts = new ArrayList<String>();}
            for (String item : items) {this.hosts.add(item);} return (A)this;
    }

    public A addAllToHosts(Collection<String> items){
            if (this.hosts == null) {this.hosts = new ArrayList<String>();}
            for (String item : items) {this.hosts.add(item);} return (A)this;
    }

    public A removeFromHosts(String... items){
            for (String item : items) {if (this.hosts!= null){ this.hosts.remove(item);}} return (A)this;
    }

    public A removeAllFromHosts(Collection<String> items){
            for (String item : items) {if (this.hosts!= null){ this.hosts.remove(item);}} return (A)this;
    }

    public List<String> getHosts(){
            return this.hosts;
    }

    public String getHost(int index){
            return this.hosts.get(index);
    }

    public String getFirstHost(){
            return this.hosts.get(0);
    }

    public String getLastHost(){
            return this.hosts.get(hosts.size() - 1);
    }

    public String getMatchingHost(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: hosts) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingHost(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: hosts) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withHosts(List<String> hosts){
            if (this.hosts != null) { _visitables.get("hosts").removeAll(this.hosts);}
            if (hosts != null) {this.hosts = new ArrayList<String>(); for (String item : hosts){this.addToHosts(item);}} else { this.hosts = null;} return (A) this;
    }

    public A withHosts(String... hosts){
            if (this.hosts != null) {this.hosts.clear();}
            if (hosts != null) {for (String item :hosts){ this.addToHosts(item);}} return (A) this;
    }

    public Boolean hasHosts(){
            return hosts != null && !hosts.isEmpty();
    }

    public A addNewHost(String arg1){
            return (A)addToHosts(new String(arg1));
    }

    public A addNewHost(StringBuilder arg1){
            return (A)addToHosts(new String(arg1));
    }

    public A addNewHost(StringBuffer arg1){
            return (A)addToHosts(new String(arg1));
    }

    public A addToMethods(int index,String item){
            if (this.methods == null) {this.methods = new ArrayList<String>();}
            this.methods.add(index, item);
            return (A)this;
    }

    public A setToMethods(int index,String item){
            if (this.methods == null) {this.methods = new ArrayList<String>();}
            this.methods.set(index, item); return (A)this;
    }

    public A addToMethods(String... items){
            if (this.methods == null) {this.methods = new ArrayList<String>();}
            for (String item : items) {this.methods.add(item);} return (A)this;
    }

    public A addAllToMethods(Collection<String> items){
            if (this.methods == null) {this.methods = new ArrayList<String>();}
            for (String item : items) {this.methods.add(item);} return (A)this;
    }

    public A removeFromMethods(String... items){
            for (String item : items) {if (this.methods!= null){ this.methods.remove(item);}} return (A)this;
    }

    public A removeAllFromMethods(Collection<String> items){
            for (String item : items) {if (this.methods!= null){ this.methods.remove(item);}} return (A)this;
    }

    public List<String> getMethods(){
            return this.methods;
    }

    public String getMethod(int index){
            return this.methods.get(index);
    }

    public String getFirstMethod(){
            return this.methods.get(0);
    }

    public String getLastMethod(){
            return this.methods.get(methods.size() - 1);
    }

    public String getMatchingMethod(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: methods) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingMethod(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: methods) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withMethods(List<String> methods){
            if (this.methods != null) { _visitables.get("methods").removeAll(this.methods);}
            if (methods != null) {this.methods = new ArrayList<String>(); for (String item : methods){this.addToMethods(item);}} else { this.methods = null;} return (A) this;
    }

    public A withMethods(String... methods){
            if (this.methods != null) {this.methods.clear();}
            if (methods != null) {for (String item :methods){ this.addToMethods(item);}} return (A) this;
    }

    public Boolean hasMethods(){
            return methods != null && !methods.isEmpty();
    }

    public A addNewMethod(String arg1){
            return (A)addToMethods(new String(arg1));
    }

    public A addNewMethod(StringBuilder arg1){
            return (A)addToMethods(new String(arg1));
    }

    public A addNewMethod(StringBuffer arg1){
            return (A)addToMethods(new String(arg1));
    }

    public A addToNotHosts(int index,String item){
            if (this.notHosts == null) {this.notHosts = new ArrayList<String>();}
            this.notHosts.add(index, item);
            return (A)this;
    }

    public A setToNotHosts(int index,String item){
            if (this.notHosts == null) {this.notHosts = new ArrayList<String>();}
            this.notHosts.set(index, item); return (A)this;
    }

    public A addToNotHosts(String... items){
            if (this.notHosts == null) {this.notHosts = new ArrayList<String>();}
            for (String item : items) {this.notHosts.add(item);} return (A)this;
    }

    public A addAllToNotHosts(Collection<String> items){
            if (this.notHosts == null) {this.notHosts = new ArrayList<String>();}
            for (String item : items) {this.notHosts.add(item);} return (A)this;
    }

    public A removeFromNotHosts(String... items){
            for (String item : items) {if (this.notHosts!= null){ this.notHosts.remove(item);}} return (A)this;
    }

    public A removeAllFromNotHosts(Collection<String> items){
            for (String item : items) {if (this.notHosts!= null){ this.notHosts.remove(item);}} return (A)this;
    }

    public List<String> getNotHosts(){
            return this.notHosts;
    }

    public String getNotHost(int index){
            return this.notHosts.get(index);
    }

    public String getFirstNotHost(){
            return this.notHosts.get(0);
    }

    public String getLastNotHost(){
            return this.notHosts.get(notHosts.size() - 1);
    }

    public String getMatchingNotHost(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: notHosts) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingNotHost(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: notHosts) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withNotHosts(List<String> notHosts){
            if (this.notHosts != null) { _visitables.get("notHosts").removeAll(this.notHosts);}
            if (notHosts != null) {this.notHosts = new ArrayList<String>(); for (String item : notHosts){this.addToNotHosts(item);}} else { this.notHosts = null;} return (A) this;
    }

    public A withNotHosts(String... notHosts){
            if (this.notHosts != null) {this.notHosts.clear();}
            if (notHosts != null) {for (String item :notHosts){ this.addToNotHosts(item);}} return (A) this;
    }

    public Boolean hasNotHosts(){
            return notHosts != null && !notHosts.isEmpty();
    }

    public A addNewNotHost(String arg1){
            return (A)addToNotHosts(new String(arg1));
    }

    public A addNewNotHost(StringBuilder arg1){
            return (A)addToNotHosts(new String(arg1));
    }

    public A addNewNotHost(StringBuffer arg1){
            return (A)addToNotHosts(new String(arg1));
    }

    public A addToNotMethods(int index,String item){
            if (this.notMethods == null) {this.notMethods = new ArrayList<String>();}
            this.notMethods.add(index, item);
            return (A)this;
    }

    public A setToNotMethods(int index,String item){
            if (this.notMethods == null) {this.notMethods = new ArrayList<String>();}
            this.notMethods.set(index, item); return (A)this;
    }

    public A addToNotMethods(String... items){
            if (this.notMethods == null) {this.notMethods = new ArrayList<String>();}
            for (String item : items) {this.notMethods.add(item);} return (A)this;
    }

    public A addAllToNotMethods(Collection<String> items){
            if (this.notMethods == null) {this.notMethods = new ArrayList<String>();}
            for (String item : items) {this.notMethods.add(item);} return (A)this;
    }

    public A removeFromNotMethods(String... items){
            for (String item : items) {if (this.notMethods!= null){ this.notMethods.remove(item);}} return (A)this;
    }

    public A removeAllFromNotMethods(Collection<String> items){
            for (String item : items) {if (this.notMethods!= null){ this.notMethods.remove(item);}} return (A)this;
    }

    public List<String> getNotMethods(){
            return this.notMethods;
    }

    public String getNotMethod(int index){
            return this.notMethods.get(index);
    }

    public String getFirstNotMethod(){
            return this.notMethods.get(0);
    }

    public String getLastNotMethod(){
            return this.notMethods.get(notMethods.size() - 1);
    }

    public String getMatchingNotMethod(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: notMethods) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingNotMethod(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: notMethods) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withNotMethods(List<String> notMethods){
            if (this.notMethods != null) { _visitables.get("notMethods").removeAll(this.notMethods);}
            if (notMethods != null) {this.notMethods = new ArrayList<String>(); for (String item : notMethods){this.addToNotMethods(item);}} else { this.notMethods = null;} return (A) this;
    }

    public A withNotMethods(String... notMethods){
            if (this.notMethods != null) {this.notMethods.clear();}
            if (notMethods != null) {for (String item :notMethods){ this.addToNotMethods(item);}} return (A) this;
    }

    public Boolean hasNotMethods(){
            return notMethods != null && !notMethods.isEmpty();
    }

    public A addNewNotMethod(String arg1){
            return (A)addToNotMethods(new String(arg1));
    }

    public A addNewNotMethod(StringBuilder arg1){
            return (A)addToNotMethods(new String(arg1));
    }

    public A addNewNotMethod(StringBuffer arg1){
            return (A)addToNotMethods(new String(arg1));
    }

    public A addToNotPaths(int index,String item){
            if (this.notPaths == null) {this.notPaths = new ArrayList<String>();}
            this.notPaths.add(index, item);
            return (A)this;
    }

    public A setToNotPaths(int index,String item){
            if (this.notPaths == null) {this.notPaths = new ArrayList<String>();}
            this.notPaths.set(index, item); return (A)this;
    }

    public A addToNotPaths(String... items){
            if (this.notPaths == null) {this.notPaths = new ArrayList<String>();}
            for (String item : items) {this.notPaths.add(item);} return (A)this;
    }

    public A addAllToNotPaths(Collection<String> items){
            if (this.notPaths == null) {this.notPaths = new ArrayList<String>();}
            for (String item : items) {this.notPaths.add(item);} return (A)this;
    }

    public A removeFromNotPaths(String... items){
            for (String item : items) {if (this.notPaths!= null){ this.notPaths.remove(item);}} return (A)this;
    }

    public A removeAllFromNotPaths(Collection<String> items){
            for (String item : items) {if (this.notPaths!= null){ this.notPaths.remove(item);}} return (A)this;
    }

    public List<String> getNotPaths(){
            return this.notPaths;
    }

    public String getNotPath(int index){
            return this.notPaths.get(index);
    }

    public String getFirstNotPath(){
            return this.notPaths.get(0);
    }

    public String getLastNotPath(){
            return this.notPaths.get(notPaths.size() - 1);
    }

    public String getMatchingNotPath(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: notPaths) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingNotPath(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: notPaths) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withNotPaths(List<String> notPaths){
            if (this.notPaths != null) { _visitables.get("notPaths").removeAll(this.notPaths);}
            if (notPaths != null) {this.notPaths = new ArrayList<String>(); for (String item : notPaths){this.addToNotPaths(item);}} else { this.notPaths = null;} return (A) this;
    }

    public A withNotPaths(String... notPaths){
            if (this.notPaths != null) {this.notPaths.clear();}
            if (notPaths != null) {for (String item :notPaths){ this.addToNotPaths(item);}} return (A) this;
    }

    public Boolean hasNotPaths(){
            return notPaths != null && !notPaths.isEmpty();
    }

    public A addNewNotPath(String arg1){
            return (A)addToNotPaths(new String(arg1));
    }

    public A addNewNotPath(StringBuilder arg1){
            return (A)addToNotPaths(new String(arg1));
    }

    public A addNewNotPath(StringBuffer arg1){
            return (A)addToNotPaths(new String(arg1));
    }

    public String getNotPorts(){
            return this.notPorts;
    }

    public A withNotPorts(String notPorts){
            this.notPorts=notPorts; return (A) this;
    }

    public Boolean hasNotPorts(){
            return this.notPorts != null;
    }

    public A withNewNotPorts(String arg1){
            return (A)withNotPorts(new String(arg1));
    }

    public A withNewNotPorts(StringBuilder arg1){
            return (A)withNotPorts(new String(arg1));
    }

    public A withNewNotPorts(StringBuffer arg1){
            return (A)withNotPorts(new String(arg1));
    }

    public A addToPaths(int index,String item){
            if (this.paths == null) {this.paths = new ArrayList<String>();}
            this.paths.add(index, item);
            return (A)this;
    }

    public A setToPaths(int index,String item){
            if (this.paths == null) {this.paths = new ArrayList<String>();}
            this.paths.set(index, item); return (A)this;
    }

    public A addToPaths(String... items){
            if (this.paths == null) {this.paths = new ArrayList<String>();}
            for (String item : items) {this.paths.add(item);} return (A)this;
    }

    public A addAllToPaths(Collection<String> items){
            if (this.paths == null) {this.paths = new ArrayList<String>();}
            for (String item : items) {this.paths.add(item);} return (A)this;
    }

    public A removeFromPaths(String... items){
            for (String item : items) {if (this.paths!= null){ this.paths.remove(item);}} return (A)this;
    }

    public A removeAllFromPaths(Collection<String> items){
            for (String item : items) {if (this.paths!= null){ this.paths.remove(item);}} return (A)this;
    }

    public List<String> getPaths(){
            return this.paths;
    }

    public String getPath(int index){
            return this.paths.get(index);
    }

    public String getFirstPath(){
            return this.paths.get(0);
    }

    public String getLastPath(){
            return this.paths.get(paths.size() - 1);
    }

    public String getMatchingPath(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: paths) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingPath(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: paths) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withPaths(List<String> paths){
            if (this.paths != null) { _visitables.get("paths").removeAll(this.paths);}
            if (paths != null) {this.paths = new ArrayList<String>(); for (String item : paths){this.addToPaths(item);}} else { this.paths = null;} return (A) this;
    }

    public A withPaths(String... paths){
            if (this.paths != null) {this.paths.clear();}
            if (paths != null) {for (String item :paths){ this.addToPaths(item);}} return (A) this;
    }

    public Boolean hasPaths(){
            return paths != null && !paths.isEmpty();
    }

    public A addNewPath(String arg1){
            return (A)addToPaths(new String(arg1));
    }

    public A addNewPath(StringBuilder arg1){
            return (A)addToPaths(new String(arg1));
    }

    public A addNewPath(StringBuffer arg1){
            return (A)addToPaths(new String(arg1));
    }

    public String getPorts(){
            return this.ports;
    }

    public A withPorts(String ports){
            this.ports=ports; return (A) this;
    }

    public Boolean hasPorts(){
            return this.ports != null;
    }

    public A withNewPorts(String arg1){
            return (A)withPorts(new String(arg1));
    }

    public A withNewPorts(StringBuilder arg1){
            return (A)withPorts(new String(arg1));
    }

    public A withNewPorts(StringBuffer arg1){
            return (A)withPorts(new String(arg1));
    }

    public A addToServices(int index,String item){
            if (this.services == null) {this.services = new ArrayList<String>();}
            this.services.add(index, item);
            return (A)this;
    }

    public A setToServices(int index,String item){
            if (this.services == null) {this.services = new ArrayList<String>();}
            this.services.set(index, item); return (A)this;
    }

    public A addToServices(String... items){
            if (this.services == null) {this.services = new ArrayList<String>();}
            for (String item : items) {this.services.add(item);} return (A)this;
    }

    public A addAllToServices(Collection<String> items){
            if (this.services == null) {this.services = new ArrayList<String>();}
            for (String item : items) {this.services.add(item);} return (A)this;
    }

    public A removeFromServices(String... items){
            for (String item : items) {if (this.services!= null){ this.services.remove(item);}} return (A)this;
    }

    public A removeAllFromServices(Collection<String> items){
            for (String item : items) {if (this.services!= null){ this.services.remove(item);}} return (A)this;
    }

    public List<String> getServices(){
            return this.services;
    }

    public String getService(int index){
            return this.services.get(index);
    }

    public String getFirstService(){
            return this.services.get(0);
    }

    public String getLastService(){
            return this.services.get(services.size() - 1);
    }

    public String getMatchingService(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: services) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingService(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: services) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withServices(List<String> services){
            if (this.services != null) { _visitables.get("services").removeAll(this.services);}
            if (services != null) {this.services = new ArrayList<String>(); for (String item : services){this.addToServices(item);}} else { this.services = null;} return (A) this;
    }

    public A withServices(String... services){
            if (this.services != null) {this.services.clear();}
            if (services != null) {for (String item :services){ this.addToServices(item);}} return (A) this;
    }

    public Boolean hasServices(){
            return services != null && !services.isEmpty();
    }

    public A addNewService(String arg1){
            return (A)addToServices(new String(arg1));
    }

    public A addNewService(StringBuilder arg1){
            return (A)addToServices(new String(arg1));
    }

    public A addNewService(StringBuffer arg1){
            return (A)addToServices(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            AccessRuleFluentImpl that = (AccessRuleFluentImpl) o;
            if (constraints != null ? !constraints.equals(that.constraints) :that.constraints != null) return false;
            if (hosts != null ? !hosts.equals(that.hosts) :that.hosts != null) return false;
            if (methods != null ? !methods.equals(that.methods) :that.methods != null) return false;
            if (notHosts != null ? !notHosts.equals(that.notHosts) :that.notHosts != null) return false;
            if (notMethods != null ? !notMethods.equals(that.notMethods) :that.notMethods != null) return false;
            if (notPaths != null ? !notPaths.equals(that.notPaths) :that.notPaths != null) return false;
            if (notPorts != null ? !notPorts.equals(that.notPorts) :that.notPorts != null) return false;
            if (paths != null ? !paths.equals(that.paths) :that.paths != null) return false;
            if (ports != null ? !ports.equals(that.ports) :that.ports != null) return false;
            if (services != null ? !services.equals(that.services) :that.services != null) return false;
            return true;
    }


    public class ConstraintsNestedImpl<N> extends ConstraintFluentImpl<AccessRuleFluent.ConstraintsNested<N>> implements AccessRuleFluent.ConstraintsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ConstraintBuilder builder;
        private final int index;
    
            ConstraintsNestedImpl(int index,Constraint item){
                    this.index = index;
                    this.builder = new ConstraintBuilder(this, item);
            }
            ConstraintsNestedImpl(){
                    this.index = -1;
                    this.builder = new ConstraintBuilder(this);
            }
    
    public N and(){
            return (N) AccessRuleFluentImpl.this.setToConstraints(index, builder.build());
    }
    public N endConstraint(){
            return and();
    }

}


}
