package me.snowdrop.istio.api.rbac.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConstraintBuilder extends ConstraintFluentImpl<ConstraintBuilder> implements VisitableBuilder<Constraint,ConstraintBuilder>{

    ConstraintFluent<?> fluent;
    Boolean validationEnabled;

    public ConstraintBuilder(){
            this(true);
    }
    public ConstraintBuilder(Boolean validationEnabled){
            this(new Constraint(), validationEnabled);
    }
    public ConstraintBuilder(ConstraintFluent<?> fluent){
            this(fluent, true);
    }
    public ConstraintBuilder(ConstraintFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Constraint(), validationEnabled);
    }
    public ConstraintBuilder(ConstraintFluent<?> fluent,Constraint instance){
            this(fluent, instance, true);
    }
    public ConstraintBuilder(ConstraintFluent<?> fluent,Constraint instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withKey(instance.getKey()); 
            fluent.withValues(instance.getValues()); 
            this.validationEnabled = validationEnabled; 
    }
    public ConstraintBuilder(Constraint instance){
            this(instance,true);
    }
    public ConstraintBuilder(Constraint instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withKey(instance.getKey()); 
            this.withValues(instance.getValues()); 
            this.validationEnabled = validationEnabled; 
    }

    public Constraint build(){
            Constraint buildable = new Constraint(fluent.getKey(),fluent.getValues());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ConstraintBuilder that = (ConstraintBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
