package me.snowdrop.istio.api.rbac.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RbacConfigBuilder extends RbacConfigFluentImpl<RbacConfigBuilder> implements VisitableBuilder<RbacConfig,RbacConfigBuilder>{

    RbacConfigFluent<?> fluent;
    Boolean validationEnabled;

    public RbacConfigBuilder(){
            this(true);
    }
    public RbacConfigBuilder(Boolean validationEnabled){
            this(new RbacConfig(), validationEnabled);
    }
    public RbacConfigBuilder(RbacConfigFluent<?> fluent){
            this(fluent, true);
    }
    public RbacConfigBuilder(RbacConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RbacConfig(), validationEnabled);
    }
    public RbacConfigBuilder(RbacConfigFluent<?> fluent,RbacConfig instance){
            this(fluent, instance, true);
    }
    public RbacConfigBuilder(RbacConfigFluent<?> fluent,RbacConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public RbacConfigBuilder(RbacConfig instance){
            this(instance,true);
    }
    public RbacConfigBuilder(RbacConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }

    public RbacConfig build(){
            RbacConfig buildable = new RbacConfig(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RbacConfigBuilder that = (RbacConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
