
package me.snowdrop.istio.api.rbac.v1alpha1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "enforcementMode",
    "exclusion",
    "inclusion",
    "mode"
})
@IstioKind(name = "RbacConfig", plural = "rbacconfigs")
@IstioApiVersion("rbac.istio.io/v1alpha1")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class RbacConfigSpec implements Serializable, IstioSpec
{

    @JsonProperty("enforcementMode")
    private EnforcementMode enforcementMode;
    /**
     * 
     * 
     */
    @JsonProperty("exclusion")
    @JsonPropertyDescription("")
    private Target exclusion;
    /**
     * 
     * 
     */
    @JsonProperty("inclusion")
    @JsonPropertyDescription("")
    private Target inclusion;
    @JsonProperty("mode")
    private Mode mode;
    private final static long serialVersionUID = -3999813242148922569L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public RbacConfigSpec() {
    }

    /**
     * 
     * @param mode
     * @param inclusion
     * @param exclusion
     * @param enforcementMode
     */
    public RbacConfigSpec(EnforcementMode enforcementMode, Target exclusion, Target inclusion, Mode mode) {
        super();
        this.enforcementMode = enforcementMode;
        this.exclusion = exclusion;
        this.inclusion = inclusion;
        this.mode = mode;
    }

    @JsonProperty("enforcementMode")
    public EnforcementMode getEnforcementMode() {
        return enforcementMode;
    }

    @JsonProperty("enforcementMode")
    public void setEnforcementMode(EnforcementMode enforcementMode) {
        this.enforcementMode = enforcementMode;
    }

    /**
     * 
     * 
     */
    @JsonProperty("exclusion")
    public Target getExclusion() {
        return exclusion;
    }

    /**
     * 
     * 
     */
    @JsonProperty("exclusion")
    public void setExclusion(Target exclusion) {
        this.exclusion = exclusion;
    }

    /**
     * 
     * 
     */
    @JsonProperty("inclusion")
    public Target getInclusion() {
        return inclusion;
    }

    /**
     * 
     * 
     */
    @JsonProperty("inclusion")
    public void setInclusion(Target inclusion) {
        this.inclusion = inclusion;
    }

    @JsonProperty("mode")
    public Mode getMode() {
        return mode;
    }

    @JsonProperty("mode")
    public void setMode(Mode mode) {
        this.mode = mode;
    }

}
