package me.snowdrop.istio.api.rbac.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RbacConfigSpecBuilder extends RbacConfigSpecFluentImpl<RbacConfigSpecBuilder> implements VisitableBuilder<RbacConfigSpec,RbacConfigSpecBuilder>{

    RbacConfigSpecFluent<?> fluent;
    Boolean validationEnabled;

    public RbacConfigSpecBuilder(){
            this(true);
    }
    public RbacConfigSpecBuilder(Boolean validationEnabled){
            this(new RbacConfigSpec(), validationEnabled);
    }
    public RbacConfigSpecBuilder(RbacConfigSpecFluent<?> fluent){
            this(fluent, true);
    }
    public RbacConfigSpecBuilder(RbacConfigSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RbacConfigSpec(), validationEnabled);
    }
    public RbacConfigSpecBuilder(RbacConfigSpecFluent<?> fluent,RbacConfigSpec instance){
            this(fluent, instance, true);
    }
    public RbacConfigSpecBuilder(RbacConfigSpecFluent<?> fluent,RbacConfigSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withEnforcementMode(instance.getEnforcementMode()); 
            fluent.withExclusion(instance.getExclusion()); 
            fluent.withInclusion(instance.getInclusion()); 
            fluent.withMode(instance.getMode()); 
            this.validationEnabled = validationEnabled; 
    }
    public RbacConfigSpecBuilder(RbacConfigSpec instance){
            this(instance,true);
    }
    public RbacConfigSpecBuilder(RbacConfigSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withEnforcementMode(instance.getEnforcementMode()); 
            this.withExclusion(instance.getExclusion()); 
            this.withInclusion(instance.getInclusion()); 
            this.withMode(instance.getMode()); 
            this.validationEnabled = validationEnabled; 
    }

    public RbacConfigSpec build(){
            RbacConfigSpec buildable = new RbacConfigSpec(fluent.getEnforcementMode(),fluent.getExclusion(),fluent.getInclusion(),fluent.getMode());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RbacConfigSpecBuilder that = (RbacConfigSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
