package me.snowdrop.istio.api.rbac.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServiceRoleBindingSpecBuilder extends ServiceRoleBindingSpecFluentImpl<ServiceRoleBindingSpecBuilder> implements VisitableBuilder<ServiceRoleBindingSpec,ServiceRoleBindingSpecBuilder>{

    ServiceRoleBindingSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceRoleBindingSpecBuilder(){
            this(true);
    }
    public ServiceRoleBindingSpecBuilder(Boolean validationEnabled){
            this(new ServiceRoleBindingSpec(), validationEnabled);
    }
    public ServiceRoleBindingSpecBuilder(ServiceRoleBindingSpecFluent<?> fluent){
            this(fluent, true);
    }
    public ServiceRoleBindingSpecBuilder(ServiceRoleBindingSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ServiceRoleBindingSpec(), validationEnabled);
    }
    public ServiceRoleBindingSpecBuilder(ServiceRoleBindingSpecFluent<?> fluent,ServiceRoleBindingSpec instance){
            this(fluent, instance, true);
    }
    public ServiceRoleBindingSpecBuilder(ServiceRoleBindingSpecFluent<?> fluent,ServiceRoleBindingSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMode(instance.getMode()); 
            fluent.withRoleRef(instance.getRoleRef()); 
            fluent.withSubjects(instance.getSubjects()); 
            this.validationEnabled = validationEnabled; 
    }
    public ServiceRoleBindingSpecBuilder(ServiceRoleBindingSpec instance){
            this(instance,true);
    }
    public ServiceRoleBindingSpecBuilder(ServiceRoleBindingSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMode(instance.getMode()); 
            this.withRoleRef(instance.getRoleRef()); 
            this.withSubjects(instance.getSubjects()); 
            this.validationEnabled = validationEnabled; 
    }

    public ServiceRoleBindingSpec build(){
            ServiceRoleBindingSpec buildable = new ServiceRoleBindingSpec(fluent.getMode(),fluent.getRoleRef(),fluent.getSubjects());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ServiceRoleBindingSpecBuilder that = (ServiceRoleBindingSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
