package me.snowdrop.istio.api.rbac.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

public class ServiceRoleBindingSpecFluentImpl<A extends ServiceRoleBindingSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ServiceRoleBindingSpecFluent<A>{

    private EnforcementMode mode;
    private RoleRefBuilder roleRef;
    private List<SubjectBuilder> subjects;

    public ServiceRoleBindingSpecFluentImpl(){
    }
    public ServiceRoleBindingSpecFluentImpl(ServiceRoleBindingSpec instance){
            this.withMode(instance.getMode()); 
            this.withRoleRef(instance.getRoleRef()); 
            this.withSubjects(instance.getSubjects()); 
    }

    public EnforcementMode getMode(){
            return this.mode;
    }

    public A withMode(EnforcementMode mode){
            this.mode=mode; return (A) this;
    }

    public Boolean hasMode(){
            return this.mode != null;
    }

    
/**
 * This method has been deprecated, please use method buildRoleRef instead.
 * @return The buildable object.
 */
@Deprecated public RoleRef getRoleRef(){
            return this.roleRef!=null?this.roleRef.build():null;
    }

    public RoleRef buildRoleRef(){
            return this.roleRef!=null?this.roleRef.build():null;
    }

    public A withRoleRef(RoleRef roleRef){
            _visitables.get("roleRef").remove(this.roleRef);
            if (roleRef!=null){ this.roleRef= new RoleRefBuilder(roleRef); _visitables.get("roleRef").add(this.roleRef);} return (A) this;
    }

    public Boolean hasRoleRef(){
            return this.roleRef != null;
    }

    public A withNewRoleRef(String kind,String name){
            return (A)withRoleRef(new RoleRef(kind, name));
    }

    public ServiceRoleBindingSpecFluent.RoleRefNested<A> withNewRoleRef(){
            return new RoleRefNestedImpl();
    }

    public ServiceRoleBindingSpecFluent.RoleRefNested<A> withNewRoleRefLike(RoleRef item){
            return new RoleRefNestedImpl(item);
    }

    public ServiceRoleBindingSpecFluent.RoleRefNested<A> editRoleRef(){
            return withNewRoleRefLike(getRoleRef());
    }

    public ServiceRoleBindingSpecFluent.RoleRefNested<A> editOrNewRoleRef(){
            return withNewRoleRefLike(getRoleRef() != null ? getRoleRef(): new RoleRefBuilder().build());
    }

    public ServiceRoleBindingSpecFluent.RoleRefNested<A> editOrNewRoleRefLike(RoleRef item){
            return withNewRoleRefLike(getRoleRef() != null ? getRoleRef(): item);
    }

    public A addToSubjects(int index,Subject item){
            if (this.subjects == null) {this.subjects = new ArrayList<SubjectBuilder>();}
            SubjectBuilder builder = new SubjectBuilder(item);_visitables.get("subjects").add(index >= 0 ? index : _visitables.get("subjects").size(), builder);this.subjects.add(index >= 0 ? index : subjects.size(), builder); return (A)this;
    }

    public A setToSubjects(int index,Subject item){
            if (this.subjects == null) {this.subjects = new ArrayList<SubjectBuilder>();}
            SubjectBuilder builder = new SubjectBuilder(item);
            if (index < 0 || index >= _visitables.get("subjects").size()) { _visitables.get("subjects").add(builder); } else { _visitables.get("subjects").set(index, builder);}
            if (index < 0 || index >= subjects.size()) { subjects.add(builder); } else { subjects.set(index, builder);}
             return (A)this;
    }

    public A addToSubjects(Subject... items){
            if (this.subjects == null) {this.subjects = new ArrayList<SubjectBuilder>();}
            for (Subject item : items) {SubjectBuilder builder = new SubjectBuilder(item);_visitables.get("subjects").add(builder);this.subjects.add(builder);} return (A)this;
    }

    public A addAllToSubjects(Collection<Subject> items){
            if (this.subjects == null) {this.subjects = new ArrayList<SubjectBuilder>();}
            for (Subject item : items) {SubjectBuilder builder = new SubjectBuilder(item);_visitables.get("subjects").add(builder);this.subjects.add(builder);} return (A)this;
    }

    public A removeFromSubjects(Subject... items){
            for (Subject item : items) {SubjectBuilder builder = new SubjectBuilder(item);_visitables.get("subjects").remove(builder);if (this.subjects != null) {this.subjects.remove(builder);}} return (A)this;
    }

    public A removeAllFromSubjects(Collection<Subject> items){
            for (Subject item : items) {SubjectBuilder builder = new SubjectBuilder(item);_visitables.get("subjects").remove(builder);if (this.subjects != null) {this.subjects.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromSubjects(io.fabric8.kubernetes.api.builder.Predicate<SubjectBuilder> predicate){
            if (subjects == null) return (A) this;
            final Iterator<SubjectBuilder> each = subjects.iterator();
            final List visitables = _visitables.get("subjects");
            while (each.hasNext()) {
              SubjectBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildSubjects instead.
 * @return The buildable object.
 */
@Deprecated public List<Subject> getSubjects(){
            return build(subjects);
    }

    public List<Subject> buildSubjects(){
            return build(subjects);
    }

    public Subject buildSubject(int index){
            return this.subjects.get(index).build();
    }

    public Subject buildFirstSubject(){
            return this.subjects.get(0).build();
    }

    public Subject buildLastSubject(){
            return this.subjects.get(subjects.size() - 1).build();
    }

    public Subject buildMatchingSubject(io.fabric8.kubernetes.api.builder.Predicate<SubjectBuilder> predicate){
            for (SubjectBuilder item: subjects) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingSubject(io.fabric8.kubernetes.api.builder.Predicate<SubjectBuilder> predicate){
            for (SubjectBuilder item: subjects) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withSubjects(List<Subject> subjects){
            if (this.subjects != null) { _visitables.get("subjects").removeAll(this.subjects);}
            if (subjects != null) {this.subjects = new ArrayList<SubjectBuilder>(); for (Subject item : subjects){this.addToSubjects(item);}} else { this.subjects = null;} return (A) this;
    }

    public A withSubjects(Subject... subjects){
            if (this.subjects != null) {this.subjects.clear();}
            if (subjects != null) {for (Subject item :subjects){ this.addToSubjects(item);}} return (A) this;
    }

    public Boolean hasSubjects(){
            return subjects != null && !subjects.isEmpty();
    }

    public ServiceRoleBindingSpecFluent.SubjectsNested<A> addNewSubject(){
            return new SubjectsNestedImpl();
    }

    public ServiceRoleBindingSpecFluent.SubjectsNested<A> addNewSubjectLike(Subject item){
            return new SubjectsNestedImpl(-1, item);
    }

    public ServiceRoleBindingSpecFluent.SubjectsNested<A> setNewSubjectLike(int index,Subject item){
            return new SubjectsNestedImpl(index, item);
    }

    public ServiceRoleBindingSpecFluent.SubjectsNested<A> editSubject(int index){
            if (subjects.size() <= index) throw new RuntimeException("Can't edit subjects. Index exceeds size.");
            return setNewSubjectLike(index, buildSubject(index));
    }

    public ServiceRoleBindingSpecFluent.SubjectsNested<A> editFirstSubject(){
            if (subjects.size() == 0) throw new RuntimeException("Can't edit first subjects. The list is empty.");
            return setNewSubjectLike(0, buildSubject(0));
    }

    public ServiceRoleBindingSpecFluent.SubjectsNested<A> editLastSubject(){
            int index = subjects.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last subjects. The list is empty.");
            return setNewSubjectLike(index, buildSubject(index));
    }

    public ServiceRoleBindingSpecFluent.SubjectsNested<A> editMatchingSubject(io.fabric8.kubernetes.api.builder.Predicate<SubjectBuilder> predicate){
            int index = -1;
            for (int i=0;i<subjects.size();i++) { 
            if (predicate.apply(subjects.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching subjects. No match found.");
            return setNewSubjectLike(index, buildSubject(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ServiceRoleBindingSpecFluentImpl that = (ServiceRoleBindingSpecFluentImpl) o;
            if (mode != null ? !mode.equals(that.mode) :that.mode != null) return false;
            if (roleRef != null ? !roleRef.equals(that.roleRef) :that.roleRef != null) return false;
            if (subjects != null ? !subjects.equals(that.subjects) :that.subjects != null) return false;
            return true;
    }


    public class RoleRefNestedImpl<N> extends RoleRefFluentImpl<ServiceRoleBindingSpecFluent.RoleRefNested<N>> implements ServiceRoleBindingSpecFluent.RoleRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RoleRefBuilder builder;
    
            RoleRefNestedImpl(RoleRef item){
                    this.builder = new RoleRefBuilder(this, item);
            }
            RoleRefNestedImpl(){
                    this.builder = new RoleRefBuilder(this);
            }
    
    public N and(){
            return (N) ServiceRoleBindingSpecFluentImpl.this.withRoleRef(builder.build());
    }
    public N endRoleRef(){
            return and();
    }

}
    public class SubjectsNestedImpl<N> extends SubjectFluentImpl<ServiceRoleBindingSpecFluent.SubjectsNested<N>> implements ServiceRoleBindingSpecFluent.SubjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SubjectBuilder builder;
        private final int index;
    
            SubjectsNestedImpl(int index,Subject item){
                    this.index = index;
                    this.builder = new SubjectBuilder(this, item);
            }
            SubjectsNestedImpl(){
                    this.index = -1;
                    this.builder = new SubjectBuilder(this);
            }
    
    public N and(){
            return (N) ServiceRoleBindingSpecFluentImpl.this.setToSubjects(index, builder.build());
    }
    public N endSubject(){
            return and();
    }

}


}
