package me.snowdrop.istio.api.rbac.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServiceRoleBuilder extends ServiceRoleFluentImpl<ServiceRoleBuilder> implements VisitableBuilder<ServiceRole,ServiceRoleBuilder>{

    ServiceRoleFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceRoleBuilder(){
            this(true);
    }
    public ServiceRoleBuilder(Boolean validationEnabled){
            this(new ServiceRole(), validationEnabled);
    }
    public ServiceRoleBuilder(ServiceRoleFluent<?> fluent){
            this(fluent, true);
    }
    public ServiceRoleBuilder(ServiceRoleFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ServiceRole(), validationEnabled);
    }
    public ServiceRoleBuilder(ServiceRoleFluent<?> fluent,ServiceRole instance){
            this(fluent, instance, true);
    }
    public ServiceRoleBuilder(ServiceRoleFluent<?> fluent,ServiceRole instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public ServiceRoleBuilder(ServiceRole instance){
            this(instance,true);
    }
    public ServiceRoleBuilder(ServiceRole instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }

    public ServiceRole build(){
            ServiceRole buildable = new ServiceRole(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ServiceRoleBuilder that = (ServiceRoleBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
