package me.snowdrop.istio.api.rbac.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface ServiceRoleListFluent<A extends ServiceRoleListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,ServiceRole item);
    public A setToItems(int index,ServiceRole item);
    public A addToItems(ServiceRole... items);
    public A addAllToItems(Collection<ServiceRole> items);
    public A removeFromItems(ServiceRole... items);
    public A removeAllFromItems(Collection<ServiceRole> items);
    public A removeMatchingFromItems(Predicate<ServiceRoleBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<ServiceRole> getItems();
    public List<ServiceRole> buildItems();
    public ServiceRole buildItem(int index);
    public ServiceRole buildFirstItem();
    public ServiceRole buildLastItem();
    public ServiceRole buildMatchingItem(Predicate<ServiceRoleBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<ServiceRoleBuilder> predicate);
    public A withItems(List<ServiceRole> items);
    public A withItems(ServiceRole... items);
    public Boolean hasItems();
    public ServiceRoleListFluent.ItemsNested<A> addNewItem();
    public ServiceRoleListFluent.ItemsNested<A> addNewItemLike(ServiceRole item);
    public ServiceRoleListFluent.ItemsNested<A> setNewItemLike(int index,ServiceRole item);
    public ServiceRoleListFluent.ItemsNested<A> editItem(int index);
    public ServiceRoleListFluent.ItemsNested<A> editFirstItem();
    public ServiceRoleListFluent.ItemsNested<A> editLastItem();
    public ServiceRoleListFluent.ItemsNested<A> editMatchingItem(Predicate<ServiceRoleBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,ServiceRoleFluent<ServiceRoleListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
