
package me.snowdrop.istio.api.rbac.v1alpha1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "rules"
})
@IstioKind(name = "ServiceRole", plural = "serviceroles")
@IstioApiVersion("rbac.istio.io/v1alpha1")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class ServiceRoleSpec implements Serializable, IstioSpec
{

    /**
     * 
     * 
     */
    @JsonProperty("rules")
    @JsonPropertyDescription("")
    private List<AccessRule> rules = new ArrayList<AccessRule>();
    private final static long serialVersionUID = 5653186706115577373L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ServiceRoleSpec() {
    }

    /**
     * 
     * @param rules
     */
    public ServiceRoleSpec(List<AccessRule> rules) {
        super();
        this.rules = rules;
    }

    /**
     * 
     * 
     */
    @JsonProperty("rules")
    public List<AccessRule> getRules() {
        return rules;
    }

    /**
     * 
     * 
     */
    @JsonProperty("rules")
    public void setRules(List<AccessRule> rules) {
        this.rules = rules;
    }

}
