
package me.snowdrop.istio.api.rbac.v1alpha1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "group",
    "groups",
    "ips",
    "names",
    "namespaces",
    "notGroups",
    "notIps",
    "notNames",
    "notNamespaces",
    "properties",
    "user"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Subject implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("group")
    @JsonPropertyDescription("")
    private java.lang.String group;
    /**
     * 
     * 
     */
    @JsonProperty("groups")
    @JsonPropertyDescription("")
    private List<java.lang.String> groups = new ArrayList<java.lang.String>();
    /**
     * 
     * 
     */
    @JsonProperty("ips")
    @JsonPropertyDescription("")
    private List<java.lang.String> ips = new ArrayList<java.lang.String>();
    /**
     * 
     * 
     */
    @JsonProperty("names")
    @JsonPropertyDescription("")
    private List<java.lang.String> names = new ArrayList<java.lang.String>();
    /**
     * 
     * 
     */
    @JsonProperty("namespaces")
    @JsonPropertyDescription("")
    private List<java.lang.String> namespaces = new ArrayList<java.lang.String>();
    /**
     * 
     * 
     */
    @JsonProperty("notGroups")
    @JsonPropertyDescription("")
    private List<java.lang.String> notGroups = new ArrayList<java.lang.String>();
    /**
     * 
     * 
     */
    @JsonProperty("notIps")
    @JsonPropertyDescription("")
    private List<java.lang.String> notIps = new ArrayList<java.lang.String>();
    /**
     * 
     * 
     */
    @JsonProperty("notNames")
    @JsonPropertyDescription("")
    private List<java.lang.String> notNames = new ArrayList<java.lang.String>();
    /**
     * 
     * 
     */
    @JsonProperty("notNamespaces")
    @JsonPropertyDescription("")
    private List<java.lang.String> notNamespaces = new ArrayList<java.lang.String>();
    /**
     * 
     * 
     */
    @JsonProperty("properties")
    @JsonPropertyDescription("")
    private Map<String, String> properties;
    /**
     * 
     * 
     */
    @JsonProperty("user")
    @JsonPropertyDescription("")
    private java.lang.String user;
    private final static long serialVersionUID = 3681874877287980448L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Subject() {
    }

    /**
     * 
     * @param names
     * @param notNames
     * @param notNamespaces
     * @param notGroups
     * @param groups
     * @param ips
     * @param user
     * @param notIps
     * @param properties
     * @param group
     * @param namespaces
     */
    public Subject(java.lang.String group, List<java.lang.String> groups, List<java.lang.String> ips, List<java.lang.String> names, List<java.lang.String> namespaces, List<java.lang.String> notGroups, List<java.lang.String> notIps, List<java.lang.String> notNames, List<java.lang.String> notNamespaces, Map<String, String> properties, java.lang.String user) {
        super();
        this.group = group;
        this.groups = groups;
        this.ips = ips;
        this.names = names;
        this.namespaces = namespaces;
        this.notGroups = notGroups;
        this.notIps = notIps;
        this.notNames = notNames;
        this.notNamespaces = notNamespaces;
        this.properties = properties;
        this.user = user;
    }

    /**
     * 
     * 
     */
    @JsonProperty("group")
    public java.lang.String getGroup() {
        return group;
    }

    /**
     * 
     * 
     */
    @JsonProperty("group")
    public void setGroup(java.lang.String group) {
        this.group = group;
    }

    /**
     * 
     * 
     */
    @JsonProperty("groups")
    public List<java.lang.String> getGroups() {
        return groups;
    }

    /**
     * 
     * 
     */
    @JsonProperty("groups")
    public void setGroups(List<java.lang.String> groups) {
        this.groups = groups;
    }

    /**
     * 
     * 
     */
    @JsonProperty("ips")
    public List<java.lang.String> getIps() {
        return ips;
    }

    /**
     * 
     * 
     */
    @JsonProperty("ips")
    public void setIps(List<java.lang.String> ips) {
        this.ips = ips;
    }

    /**
     * 
     * 
     */
    @JsonProperty("names")
    public List<java.lang.String> getNames() {
        return names;
    }

    /**
     * 
     * 
     */
    @JsonProperty("names")
    public void setNames(List<java.lang.String> names) {
        this.names = names;
    }

    /**
     * 
     * 
     */
    @JsonProperty("namespaces")
    public List<java.lang.String> getNamespaces() {
        return namespaces;
    }

    /**
     * 
     * 
     */
    @JsonProperty("namespaces")
    public void setNamespaces(List<java.lang.String> namespaces) {
        this.namespaces = namespaces;
    }

    /**
     * 
     * 
     */
    @JsonProperty("notGroups")
    public List<java.lang.String> getNotGroups() {
        return notGroups;
    }

    /**
     * 
     * 
     */
    @JsonProperty("notGroups")
    public void setNotGroups(List<java.lang.String> notGroups) {
        this.notGroups = notGroups;
    }

    /**
     * 
     * 
     */
    @JsonProperty("notIps")
    public List<java.lang.String> getNotIps() {
        return notIps;
    }

    /**
     * 
     * 
     */
    @JsonProperty("notIps")
    public void setNotIps(List<java.lang.String> notIps) {
        this.notIps = notIps;
    }

    /**
     * 
     * 
     */
    @JsonProperty("notNames")
    public List<java.lang.String> getNotNames() {
        return notNames;
    }

    /**
     * 
     * 
     */
    @JsonProperty("notNames")
    public void setNotNames(List<java.lang.String> notNames) {
        this.notNames = notNames;
    }

    /**
     * 
     * 
     */
    @JsonProperty("notNamespaces")
    public List<java.lang.String> getNotNamespaces() {
        return notNamespaces;
    }

    /**
     * 
     * 
     */
    @JsonProperty("notNamespaces")
    public void setNotNamespaces(List<java.lang.String> notNamespaces) {
        this.notNamespaces = notNamespaces;
    }

    /**
     * 
     * 
     */
    @JsonProperty("properties")
    public Map<String, String> getProperties() {
        return properties;
    }

    /**
     * 
     * 
     */
    @JsonProperty("properties")
    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    /**
     * 
     * 
     */
    @JsonProperty("user")
    public java.lang.String getUser() {
        return user;
    }

    /**
     * 
     * 
     */
    @JsonProperty("user")
    public void setUser(java.lang.String user) {
        this.user = user;
    }

}
