package me.snowdrop.istio.api.rbac.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SubjectBuilder extends SubjectFluentImpl<SubjectBuilder> implements VisitableBuilder<Subject,SubjectBuilder>{

    SubjectFluent<?> fluent;
    Boolean validationEnabled;

    public SubjectBuilder(){
            this(true);
    }
    public SubjectBuilder(Boolean validationEnabled){
            this(new Subject(), validationEnabled);
    }
    public SubjectBuilder(SubjectFluent<?> fluent){
            this(fluent, true);
    }
    public SubjectBuilder(SubjectFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Subject(), validationEnabled);
    }
    public SubjectBuilder(SubjectFluent<?> fluent,Subject instance){
            this(fluent, instance, true);
    }
    public SubjectBuilder(SubjectFluent<?> fluent,Subject instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withGroup(instance.getGroup()); 
            fluent.withGroups(instance.getGroups()); 
            fluent.withIps(instance.getIps()); 
            fluent.withNames(instance.getNames()); 
            fluent.withNamespaces(instance.getNamespaces()); 
            fluent.withNotGroups(instance.getNotGroups()); 
            fluent.withNotIps(instance.getNotIps()); 
            fluent.withNotNames(instance.getNotNames()); 
            fluent.withNotNamespaces(instance.getNotNamespaces()); 
            fluent.withProperties(instance.getProperties()); 
            fluent.withUser(instance.getUser()); 
            this.validationEnabled = validationEnabled; 
    }
    public SubjectBuilder(Subject instance){
            this(instance,true);
    }
    public SubjectBuilder(Subject instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withGroup(instance.getGroup()); 
            this.withGroups(instance.getGroups()); 
            this.withIps(instance.getIps()); 
            this.withNames(instance.getNames()); 
            this.withNamespaces(instance.getNamespaces()); 
            this.withNotGroups(instance.getNotGroups()); 
            this.withNotIps(instance.getNotIps()); 
            this.withNotNames(instance.getNotNames()); 
            this.withNotNamespaces(instance.getNotNamespaces()); 
            this.withProperties(instance.getProperties()); 
            this.withUser(instance.getUser()); 
            this.validationEnabled = validationEnabled; 
    }

    public Subject build(){
            Subject buildable = new Subject(fluent.getGroup(),fluent.getGroups(),fluent.getIps(),fluent.getNames(),fluent.getNamespaces(),fluent.getNotGroups(),fluent.getNotIps(),fluent.getNotNames(),fluent.getNotNamespaces(),fluent.getProperties(),fluent.getUser());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SubjectBuilder that = (SubjectBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
