package me.snowdrop.istio.api.rbac.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public class SubjectFluentImpl<A extends SubjectFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SubjectFluent<A>{

    private String group;
    private List<String> groups;
    private List<String> ips;
    private List<String> names;
    private List<String> namespaces;
    private List<String> notGroups;
    private List<String> notIps;
    private List<String> notNames;
    private List<String> notNamespaces;
    private Map<String,String> properties;
    private String user;

    public SubjectFluentImpl(){
    }
    public SubjectFluentImpl(Subject instance){
            this.withGroup(instance.getGroup()); 
            this.withGroups(instance.getGroups()); 
            this.withIps(instance.getIps()); 
            this.withNames(instance.getNames()); 
            this.withNamespaces(instance.getNamespaces()); 
            this.withNotGroups(instance.getNotGroups()); 
            this.withNotIps(instance.getNotIps()); 
            this.withNotNames(instance.getNotNames()); 
            this.withNotNamespaces(instance.getNotNamespaces()); 
            this.withProperties(instance.getProperties()); 
            this.withUser(instance.getUser()); 
    }

    public String getGroup(){
            return this.group;
    }

    public A withGroup(String group){
            this.group=group; return (A) this;
    }

    public Boolean hasGroup(){
            return this.group != null;
    }

    public A withNewGroup(String arg1){
            return (A)withGroup(new String(arg1));
    }

    public A withNewGroup(StringBuilder arg1){
            return (A)withGroup(new String(arg1));
    }

    public A withNewGroup(StringBuffer arg1){
            return (A)withGroup(new String(arg1));
    }

    public A addToGroups(int index,String item){
            if (this.groups == null) {this.groups = new ArrayList<String>();}
            this.groups.add(index, item);
            return (A)this;
    }

    public A setToGroups(int index,String item){
            if (this.groups == null) {this.groups = new ArrayList<String>();}
            this.groups.set(index, item); return (A)this;
    }

    public A addToGroups(String... items){
            if (this.groups == null) {this.groups = new ArrayList<String>();}
            for (String item : items) {this.groups.add(item);} return (A)this;
    }

    public A addAllToGroups(Collection<String> items){
            if (this.groups == null) {this.groups = new ArrayList<String>();}
            for (String item : items) {this.groups.add(item);} return (A)this;
    }

    public A removeFromGroups(String... items){
            for (String item : items) {if (this.groups!= null){ this.groups.remove(item);}} return (A)this;
    }

    public A removeAllFromGroups(Collection<String> items){
            for (String item : items) {if (this.groups!= null){ this.groups.remove(item);}} return (A)this;
    }

    public List<String> getGroups(){
            return this.groups;
    }

    public String getGroup(int index){
            return this.groups.get(index);
    }

    public String getFirstGroup(){
            return this.groups.get(0);
    }

    public String getLastGroup(){
            return this.groups.get(groups.size() - 1);
    }

    public String getMatchingGroup(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: groups) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingGroup(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: groups) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withGroups(List<String> groups){
            if (this.groups != null) { _visitables.get("groups").removeAll(this.groups);}
            if (groups != null) {this.groups = new ArrayList<String>(); for (String item : groups){this.addToGroups(item);}} else { this.groups = null;} return (A) this;
    }

    public A withGroups(String... groups){
            if (this.groups != null) {this.groups.clear();}
            if (groups != null) {for (String item :groups){ this.addToGroups(item);}} return (A) this;
    }

    public Boolean hasGroups(){
            return groups != null && !groups.isEmpty();
    }

    public A addNewGroup(String arg1){
            return (A)addToGroups(new String(arg1));
    }

    public A addNewGroup(StringBuilder arg1){
            return (A)addToGroups(new String(arg1));
    }

    public A addNewGroup(StringBuffer arg1){
            return (A)addToGroups(new String(arg1));
    }

    public A addToIps(int index,String item){
            if (this.ips == null) {this.ips = new ArrayList<String>();}
            this.ips.add(index, item);
            return (A)this;
    }

    public A setToIps(int index,String item){
            if (this.ips == null) {this.ips = new ArrayList<String>();}
            this.ips.set(index, item); return (A)this;
    }

    public A addToIps(String... items){
            if (this.ips == null) {this.ips = new ArrayList<String>();}
            for (String item : items) {this.ips.add(item);} return (A)this;
    }

    public A addAllToIps(Collection<String> items){
            if (this.ips == null) {this.ips = new ArrayList<String>();}
            for (String item : items) {this.ips.add(item);} return (A)this;
    }

    public A removeFromIps(String... items){
            for (String item : items) {if (this.ips!= null){ this.ips.remove(item);}} return (A)this;
    }

    public A removeAllFromIps(Collection<String> items){
            for (String item : items) {if (this.ips!= null){ this.ips.remove(item);}} return (A)this;
    }

    public List<String> getIps(){
            return this.ips;
    }

    public String getIp(int index){
            return this.ips.get(index);
    }

    public String getFirstIp(){
            return this.ips.get(0);
    }

    public String getLastIp(){
            return this.ips.get(ips.size() - 1);
    }

    public String getMatchingIp(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: ips) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingIp(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: ips) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withIps(List<String> ips){
            if (this.ips != null) { _visitables.get("ips").removeAll(this.ips);}
            if (ips != null) {this.ips = new ArrayList<String>(); for (String item : ips){this.addToIps(item);}} else { this.ips = null;} return (A) this;
    }

    public A withIps(String... ips){
            if (this.ips != null) {this.ips.clear();}
            if (ips != null) {for (String item :ips){ this.addToIps(item);}} return (A) this;
    }

    public Boolean hasIps(){
            return ips != null && !ips.isEmpty();
    }

    public A addNewIp(String arg1){
            return (A)addToIps(new String(arg1));
    }

    public A addNewIp(StringBuilder arg1){
            return (A)addToIps(new String(arg1));
    }

    public A addNewIp(StringBuffer arg1){
            return (A)addToIps(new String(arg1));
    }

    public A addToNames(int index,String item){
            if (this.names == null) {this.names = new ArrayList<String>();}
            this.names.add(index, item);
            return (A)this;
    }

    public A setToNames(int index,String item){
            if (this.names == null) {this.names = new ArrayList<String>();}
            this.names.set(index, item); return (A)this;
    }

    public A addToNames(String... items){
            if (this.names == null) {this.names = new ArrayList<String>();}
            for (String item : items) {this.names.add(item);} return (A)this;
    }

    public A addAllToNames(Collection<String> items){
            if (this.names == null) {this.names = new ArrayList<String>();}
            for (String item : items) {this.names.add(item);} return (A)this;
    }

    public A removeFromNames(String... items){
            for (String item : items) {if (this.names!= null){ this.names.remove(item);}} return (A)this;
    }

    public A removeAllFromNames(Collection<String> items){
            for (String item : items) {if (this.names!= null){ this.names.remove(item);}} return (A)this;
    }

    public List<String> getNames(){
            return this.names;
    }

    public String getName(int index){
            return this.names.get(index);
    }

    public String getFirstName(){
            return this.names.get(0);
    }

    public String getLastName(){
            return this.names.get(names.size() - 1);
    }

    public String getMatchingName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: names) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: names) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withNames(List<String> names){
            if (this.names != null) { _visitables.get("names").removeAll(this.names);}
            if (names != null) {this.names = new ArrayList<String>(); for (String item : names){this.addToNames(item);}} else { this.names = null;} return (A) this;
    }

    public A withNames(String... names){
            if (this.names != null) {this.names.clear();}
            if (names != null) {for (String item :names){ this.addToNames(item);}} return (A) this;
    }

    public Boolean hasNames(){
            return names != null && !names.isEmpty();
    }

    public A addNewName(String arg1){
            return (A)addToNames(new String(arg1));
    }

    public A addNewName(StringBuilder arg1){
            return (A)addToNames(new String(arg1));
    }

    public A addNewName(StringBuffer arg1){
            return (A)addToNames(new String(arg1));
    }

    public A addToNamespaces(int index,String item){
            if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
            this.namespaces.add(index, item);
            return (A)this;
    }

    public A setToNamespaces(int index,String item){
            if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
            this.namespaces.set(index, item); return (A)this;
    }

    public A addToNamespaces(String... items){
            if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
            for (String item : items) {this.namespaces.add(item);} return (A)this;
    }

    public A addAllToNamespaces(Collection<String> items){
            if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
            for (String item : items) {this.namespaces.add(item);} return (A)this;
    }

    public A removeFromNamespaces(String... items){
            for (String item : items) {if (this.namespaces!= null){ this.namespaces.remove(item);}} return (A)this;
    }

    public A removeAllFromNamespaces(Collection<String> items){
            for (String item : items) {if (this.namespaces!= null){ this.namespaces.remove(item);}} return (A)this;
    }

    public List<String> getNamespaces(){
            return this.namespaces;
    }

    public String getNamespace(int index){
            return this.namespaces.get(index);
    }

    public String getFirstNamespace(){
            return this.namespaces.get(0);
    }

    public String getLastNamespace(){
            return this.namespaces.get(namespaces.size() - 1);
    }

    public String getMatchingNamespace(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: namespaces) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingNamespace(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: namespaces) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withNamespaces(List<String> namespaces){
            if (this.namespaces != null) { _visitables.get("namespaces").removeAll(this.namespaces);}
            if (namespaces != null) {this.namespaces = new ArrayList<String>(); for (String item : namespaces){this.addToNamespaces(item);}} else { this.namespaces = null;} return (A) this;
    }

    public A withNamespaces(String... namespaces){
            if (this.namespaces != null) {this.namespaces.clear();}
            if (namespaces != null) {for (String item :namespaces){ this.addToNamespaces(item);}} return (A) this;
    }

    public Boolean hasNamespaces(){
            return namespaces != null && !namespaces.isEmpty();
    }

    public A addNewNamespace(String arg1){
            return (A)addToNamespaces(new String(arg1));
    }

    public A addNewNamespace(StringBuilder arg1){
            return (A)addToNamespaces(new String(arg1));
    }

    public A addNewNamespace(StringBuffer arg1){
            return (A)addToNamespaces(new String(arg1));
    }

    public A addToNotGroups(int index,String item){
            if (this.notGroups == null) {this.notGroups = new ArrayList<String>();}
            this.notGroups.add(index, item);
            return (A)this;
    }

    public A setToNotGroups(int index,String item){
            if (this.notGroups == null) {this.notGroups = new ArrayList<String>();}
            this.notGroups.set(index, item); return (A)this;
    }

    public A addToNotGroups(String... items){
            if (this.notGroups == null) {this.notGroups = new ArrayList<String>();}
            for (String item : items) {this.notGroups.add(item);} return (A)this;
    }

    public A addAllToNotGroups(Collection<String> items){
            if (this.notGroups == null) {this.notGroups = new ArrayList<String>();}
            for (String item : items) {this.notGroups.add(item);} return (A)this;
    }

    public A removeFromNotGroups(String... items){
            for (String item : items) {if (this.notGroups!= null){ this.notGroups.remove(item);}} return (A)this;
    }

    public A removeAllFromNotGroups(Collection<String> items){
            for (String item : items) {if (this.notGroups!= null){ this.notGroups.remove(item);}} return (A)this;
    }

    public List<String> getNotGroups(){
            return this.notGroups;
    }

    public String getNotGroup(int index){
            return this.notGroups.get(index);
    }

    public String getFirstNotGroup(){
            return this.notGroups.get(0);
    }

    public String getLastNotGroup(){
            return this.notGroups.get(notGroups.size() - 1);
    }

    public String getMatchingNotGroup(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: notGroups) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingNotGroup(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: notGroups) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withNotGroups(List<String> notGroups){
            if (this.notGroups != null) { _visitables.get("notGroups").removeAll(this.notGroups);}
            if (notGroups != null) {this.notGroups = new ArrayList<String>(); for (String item : notGroups){this.addToNotGroups(item);}} else { this.notGroups = null;} return (A) this;
    }

    public A withNotGroups(String... notGroups){
            if (this.notGroups != null) {this.notGroups.clear();}
            if (notGroups != null) {for (String item :notGroups){ this.addToNotGroups(item);}} return (A) this;
    }

    public Boolean hasNotGroups(){
            return notGroups != null && !notGroups.isEmpty();
    }

    public A addNewNotGroup(String arg1){
            return (A)addToNotGroups(new String(arg1));
    }

    public A addNewNotGroup(StringBuilder arg1){
            return (A)addToNotGroups(new String(arg1));
    }

    public A addNewNotGroup(StringBuffer arg1){
            return (A)addToNotGroups(new String(arg1));
    }

    public A addToNotIps(int index,String item){
            if (this.notIps == null) {this.notIps = new ArrayList<String>();}
            this.notIps.add(index, item);
            return (A)this;
    }

    public A setToNotIps(int index,String item){
            if (this.notIps == null) {this.notIps = new ArrayList<String>();}
            this.notIps.set(index, item); return (A)this;
    }

    public A addToNotIps(String... items){
            if (this.notIps == null) {this.notIps = new ArrayList<String>();}
            for (String item : items) {this.notIps.add(item);} return (A)this;
    }

    public A addAllToNotIps(Collection<String> items){
            if (this.notIps == null) {this.notIps = new ArrayList<String>();}
            for (String item : items) {this.notIps.add(item);} return (A)this;
    }

    public A removeFromNotIps(String... items){
            for (String item : items) {if (this.notIps!= null){ this.notIps.remove(item);}} return (A)this;
    }

    public A removeAllFromNotIps(Collection<String> items){
            for (String item : items) {if (this.notIps!= null){ this.notIps.remove(item);}} return (A)this;
    }

    public List<String> getNotIps(){
            return this.notIps;
    }

    public String getNotIp(int index){
            return this.notIps.get(index);
    }

    public String getFirstNotIp(){
            return this.notIps.get(0);
    }

    public String getLastNotIp(){
            return this.notIps.get(notIps.size() - 1);
    }

    public String getMatchingNotIp(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: notIps) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingNotIp(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: notIps) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withNotIps(List<String> notIps){
            if (this.notIps != null) { _visitables.get("notIps").removeAll(this.notIps);}
            if (notIps != null) {this.notIps = new ArrayList<String>(); for (String item : notIps){this.addToNotIps(item);}} else { this.notIps = null;} return (A) this;
    }

    public A withNotIps(String... notIps){
            if (this.notIps != null) {this.notIps.clear();}
            if (notIps != null) {for (String item :notIps){ this.addToNotIps(item);}} return (A) this;
    }

    public Boolean hasNotIps(){
            return notIps != null && !notIps.isEmpty();
    }

    public A addNewNotIp(String arg1){
            return (A)addToNotIps(new String(arg1));
    }

    public A addNewNotIp(StringBuilder arg1){
            return (A)addToNotIps(new String(arg1));
    }

    public A addNewNotIp(StringBuffer arg1){
            return (A)addToNotIps(new String(arg1));
    }

    public A addToNotNames(int index,String item){
            if (this.notNames == null) {this.notNames = new ArrayList<String>();}
            this.notNames.add(index, item);
            return (A)this;
    }

    public A setToNotNames(int index,String item){
            if (this.notNames == null) {this.notNames = new ArrayList<String>();}
            this.notNames.set(index, item); return (A)this;
    }

    public A addToNotNames(String... items){
            if (this.notNames == null) {this.notNames = new ArrayList<String>();}
            for (String item : items) {this.notNames.add(item);} return (A)this;
    }

    public A addAllToNotNames(Collection<String> items){
            if (this.notNames == null) {this.notNames = new ArrayList<String>();}
            for (String item : items) {this.notNames.add(item);} return (A)this;
    }

    public A removeFromNotNames(String... items){
            for (String item : items) {if (this.notNames!= null){ this.notNames.remove(item);}} return (A)this;
    }

    public A removeAllFromNotNames(Collection<String> items){
            for (String item : items) {if (this.notNames!= null){ this.notNames.remove(item);}} return (A)this;
    }

    public List<String> getNotNames(){
            return this.notNames;
    }

    public String getNotName(int index){
            return this.notNames.get(index);
    }

    public String getFirstNotName(){
            return this.notNames.get(0);
    }

    public String getLastNotName(){
            return this.notNames.get(notNames.size() - 1);
    }

    public String getMatchingNotName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: notNames) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingNotName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: notNames) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withNotNames(List<String> notNames){
            if (this.notNames != null) { _visitables.get("notNames").removeAll(this.notNames);}
            if (notNames != null) {this.notNames = new ArrayList<String>(); for (String item : notNames){this.addToNotNames(item);}} else { this.notNames = null;} return (A) this;
    }

    public A withNotNames(String... notNames){
            if (this.notNames != null) {this.notNames.clear();}
            if (notNames != null) {for (String item :notNames){ this.addToNotNames(item);}} return (A) this;
    }

    public Boolean hasNotNames(){
            return notNames != null && !notNames.isEmpty();
    }

    public A addNewNotName(String arg1){
            return (A)addToNotNames(new String(arg1));
    }

    public A addNewNotName(StringBuilder arg1){
            return (A)addToNotNames(new String(arg1));
    }

    public A addNewNotName(StringBuffer arg1){
            return (A)addToNotNames(new String(arg1));
    }

    public A addToNotNamespaces(int index,String item){
            if (this.notNamespaces == null) {this.notNamespaces = new ArrayList<String>();}
            this.notNamespaces.add(index, item);
            return (A)this;
    }

    public A setToNotNamespaces(int index,String item){
            if (this.notNamespaces == null) {this.notNamespaces = new ArrayList<String>();}
            this.notNamespaces.set(index, item); return (A)this;
    }

    public A addToNotNamespaces(String... items){
            if (this.notNamespaces == null) {this.notNamespaces = new ArrayList<String>();}
            for (String item : items) {this.notNamespaces.add(item);} return (A)this;
    }

    public A addAllToNotNamespaces(Collection<String> items){
            if (this.notNamespaces == null) {this.notNamespaces = new ArrayList<String>();}
            for (String item : items) {this.notNamespaces.add(item);} return (A)this;
    }

    public A removeFromNotNamespaces(String... items){
            for (String item : items) {if (this.notNamespaces!= null){ this.notNamespaces.remove(item);}} return (A)this;
    }

    public A removeAllFromNotNamespaces(Collection<String> items){
            for (String item : items) {if (this.notNamespaces!= null){ this.notNamespaces.remove(item);}} return (A)this;
    }

    public List<String> getNotNamespaces(){
            return this.notNamespaces;
    }

    public String getNotNamespace(int index){
            return this.notNamespaces.get(index);
    }

    public String getFirstNotNamespace(){
            return this.notNamespaces.get(0);
    }

    public String getLastNotNamespace(){
            return this.notNamespaces.get(notNamespaces.size() - 1);
    }

    public String getMatchingNotNamespace(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: notNamespaces) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingNotNamespace(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: notNamespaces) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withNotNamespaces(List<String> notNamespaces){
            if (this.notNamespaces != null) { _visitables.get("notNamespaces").removeAll(this.notNamespaces);}
            if (notNamespaces != null) {this.notNamespaces = new ArrayList<String>(); for (String item : notNamespaces){this.addToNotNamespaces(item);}} else { this.notNamespaces = null;} return (A) this;
    }

    public A withNotNamespaces(String... notNamespaces){
            if (this.notNamespaces != null) {this.notNamespaces.clear();}
            if (notNamespaces != null) {for (String item :notNamespaces){ this.addToNotNamespaces(item);}} return (A) this;
    }

    public Boolean hasNotNamespaces(){
            return notNamespaces != null && !notNamespaces.isEmpty();
    }

    public A addNewNotNamespace(String arg1){
            return (A)addToNotNamespaces(new String(arg1));
    }

    public A addNewNotNamespace(StringBuilder arg1){
            return (A)addToNotNamespaces(new String(arg1));
    }

    public A addNewNotNamespace(StringBuffer arg1){
            return (A)addToNotNamespaces(new String(arg1));
    }

    public A addToProperties(String key,String value){
            if(this.properties == null && key != null && value != null) { this.properties = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.properties.put(key, value);} return (A)this;
    }

    public A addToProperties(Map<String,String> map){
            if(this.properties == null && map != null) { this.properties = new LinkedHashMap<String,String>(); }
            if(map != null) { this.properties.putAll(map);} return (A)this;
    }

    public A removeFromProperties(String key){
            if(this.properties == null) { return (A) this; }
            if(key != null && this.properties != null) {this.properties.remove(key);} return (A)this;
    }

    public A removeFromProperties(Map<String,String> map){
            if(this.properties == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.properties != null){this.properties.remove(key);}}} return (A)this;
    }

    public Map<String,String> getProperties(){
            return this.properties;
    }

    public A withProperties(Map<String,String> properties){
            if (properties == null) { this.properties =  null;} else {this.properties = new LinkedHashMap<String,String>(properties);} return (A) this;
    }

    public Boolean hasProperties(){
            return this.properties != null;
    }

    public String getUser(){
            return this.user;
    }

    public A withUser(String user){
            this.user=user; return (A) this;
    }

    public Boolean hasUser(){
            return this.user != null;
    }

    public A withNewUser(String arg1){
            return (A)withUser(new String(arg1));
    }

    public A withNewUser(StringBuilder arg1){
            return (A)withUser(new String(arg1));
    }

    public A withNewUser(StringBuffer arg1){
            return (A)withUser(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            SubjectFluentImpl that = (SubjectFluentImpl) o;
            if (group != null ? !group.equals(that.group) :that.group != null) return false;
            if (groups != null ? !groups.equals(that.groups) :that.groups != null) return false;
            if (ips != null ? !ips.equals(that.ips) :that.ips != null) return false;
            if (names != null ? !names.equals(that.names) :that.names != null) return false;
            if (namespaces != null ? !namespaces.equals(that.namespaces) :that.namespaces != null) return false;
            if (notGroups != null ? !notGroups.equals(that.notGroups) :that.notGroups != null) return false;
            if (notIps != null ? !notIps.equals(that.notIps) :that.notIps != null) return false;
            if (notNames != null ? !notNames.equals(that.notNames) :that.notNames != null) return false;
            if (notNamespaces != null ? !notNamespaces.equals(that.notNamespaces) :that.notNamespaces != null) return false;
            if (properties != null ? !properties.equals(that.properties) :that.properties != null) return false;
            if (user != null ? !user.equals(that.user) :that.user != null) return false;
            return true;
    }




}
