
package me.snowdrop.istio.api.rbac.v1alpha1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "namespaces",
    "services",
    "workloadSelectors"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Target implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("namespaces")
    @JsonPropertyDescription("")
    private List<String> namespaces = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("services")
    @JsonPropertyDescription("")
    private List<String> services = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("workloadSelectors")
    @JsonPropertyDescription("")
    private List<WorkloadSelector> workloadSelectors = new ArrayList<WorkloadSelector>();
    private final static long serialVersionUID = -8628966622673969690L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Target() {
    }

    /**
     * 
     * @param workloadSelectors
     * @param services
     * @param namespaces
     */
    public Target(List<String> namespaces, List<String> services, List<WorkloadSelector> workloadSelectors) {
        super();
        this.namespaces = namespaces;
        this.services = services;
        this.workloadSelectors = workloadSelectors;
    }

    /**
     * 
     * 
     */
    @JsonProperty("namespaces")
    public List<String> getNamespaces() {
        return namespaces;
    }

    /**
     * 
     * 
     */
    @JsonProperty("namespaces")
    public void setNamespaces(List<String> namespaces) {
        this.namespaces = namespaces;
    }

    /**
     * 
     * 
     */
    @JsonProperty("services")
    public List<String> getServices() {
        return services;
    }

    /**
     * 
     * 
     */
    @JsonProperty("services")
    public void setServices(List<String> services) {
        this.services = services;
    }

    /**
     * 
     * 
     */
    @JsonProperty("workloadSelectors")
    public List<WorkloadSelector> getWorkloadSelectors() {
        return workloadSelectors;
    }

    /**
     * 
     * 
     */
    @JsonProperty("workloadSelectors")
    public void setWorkloadSelectors(List<WorkloadSelector> workloadSelectors) {
        this.workloadSelectors = workloadSelectors;
    }

}
