package me.snowdrop.istio.api.rbac.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TargetBuilder extends TargetFluentImpl<TargetBuilder> implements VisitableBuilder<me.snowdrop.istio.api.rbac.v1alpha1.Target,TargetBuilder>{

    TargetFluent<?> fluent;
    Boolean validationEnabled;

    public TargetBuilder(){
            this(true);
    }
    public TargetBuilder(Boolean validationEnabled){
            this(new Target(), validationEnabled);
    }
    public TargetBuilder(TargetFluent<?> fluent){
            this(fluent, true);
    }
    public TargetBuilder(TargetFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Target(), validationEnabled);
    }
    public TargetBuilder(TargetFluent<?> fluent,me.snowdrop.istio.api.rbac.v1alpha1.Target instance){
            this(fluent, instance, true);
    }
    public TargetBuilder(TargetFluent<?> fluent,me.snowdrop.istio.api.rbac.v1alpha1.Target instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withNamespaces(instance.getNamespaces()); 
            fluent.withServices(instance.getServices()); 
            fluent.withWorkloadSelectors(instance.getWorkloadSelectors()); 
            this.validationEnabled = validationEnabled; 
    }
    public TargetBuilder(me.snowdrop.istio.api.rbac.v1alpha1.Target instance){
            this(instance,true);
    }
    public TargetBuilder(me.snowdrop.istio.api.rbac.v1alpha1.Target instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withNamespaces(instance.getNamespaces()); 
            this.withServices(instance.getServices()); 
            this.withWorkloadSelectors(instance.getWorkloadSelectors()); 
            this.validationEnabled = validationEnabled; 
    }

    public me.snowdrop.istio.api.rbac.v1alpha1.Target build(){
            Target buildable = new Target(fluent.getNamespaces(),fluent.getServices(),fluent.getWorkloadSelectors());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TargetBuilder that = (TargetBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
