package me.snowdrop.istio.api.rbac.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface TargetFluent<A extends TargetFluent<A>> extends Fluent<A>{


    public A addToNamespaces(int index,String item);
    public A setToNamespaces(int index,String item);
    public A addToNamespaces(String... items);
    public A addAllToNamespaces(Collection<String> items);
    public A removeFromNamespaces(String... items);
    public A removeAllFromNamespaces(Collection<String> items);
    public List<String> getNamespaces();
    public String getNamespace(int index);
    public String getFirstNamespace();
    public String getLastNamespace();
    public String getMatchingNamespace(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingNamespace(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withNamespaces(List<String> namespaces);
    public A withNamespaces(String... namespaces);
    public Boolean hasNamespaces();
    public A addNewNamespace(String arg1);
    public A addNewNamespace(StringBuilder arg1);
    public A addNewNamespace(StringBuffer arg1);
    public A addToServices(int index,String item);
    public A setToServices(int index,String item);
    public A addToServices(String... items);
    public A addAllToServices(Collection<String> items);
    public A removeFromServices(String... items);
    public A removeAllFromServices(Collection<String> items);
    public List<String> getServices();
    public String getService(int index);
    public String getFirstService();
    public String getLastService();
    public String getMatchingService(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingService(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withServices(List<String> services);
    public A withServices(String... services);
    public Boolean hasServices();
    public A addNewService(String arg1);
    public A addNewService(StringBuilder arg1);
    public A addNewService(StringBuffer arg1);
    public A addToWorkloadSelectors(int index,me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelector item);
    public A setToWorkloadSelectors(int index,me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelector item);
    public A addToWorkloadSelectors(me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelector... items);
    public A addAllToWorkloadSelectors(Collection<me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelector> items);
    public A removeFromWorkloadSelectors(me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelector... items);
    public A removeAllFromWorkloadSelectors(Collection<me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelector> items);
    public A removeMatchingFromWorkloadSelectors(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelectorBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildWorkloadSelectors instead.
 * @return The buildable object.
 */
@Deprecated public List<me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelector> getWorkloadSelectors();
    public List<me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelector> buildWorkloadSelectors();
    public me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelector buildWorkloadSelector(int index);
    public me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelector buildFirstWorkloadSelector();
    public me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelector buildLastWorkloadSelector();
    public me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelector buildMatchingWorkloadSelector(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelectorBuilder> predicate);
    public Boolean hasMatchingWorkloadSelector(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelectorBuilder> predicate);
    public A withWorkloadSelectors(List<me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelector> workloadSelectors);
    public A withWorkloadSelectors(me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelector... workloadSelectors);
    public Boolean hasWorkloadSelectors();
    public TargetFluent.WorkloadSelectorsNested<A> addNewWorkloadSelector();
    public TargetFluent.WorkloadSelectorsNested<A> addNewWorkloadSelectorLike(me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelector item);
    public TargetFluent.WorkloadSelectorsNested<A> setNewWorkloadSelectorLike(int index,me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelector item);
    public TargetFluent.WorkloadSelectorsNested<A> editWorkloadSelector(int index);
    public TargetFluent.WorkloadSelectorsNested<A> editFirstWorkloadSelector();
    public TargetFluent.WorkloadSelectorsNested<A> editLastWorkloadSelector();
    public TargetFluent.WorkloadSelectorsNested<A> editMatchingWorkloadSelector(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelectorBuilder> predicate);

    public interface WorkloadSelectorsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelectorFluent<TargetFluent.WorkloadSelectorsNested<N>>{

        
    public N and();    public N endWorkloadSelector();
}


}
