package me.snowdrop.istio.api.rbac.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class TargetFluentImpl<A extends TargetFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TargetFluent<A>{

    private List<String> namespaces;
    private List<String> services;
    private List<me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelectorBuilder> workloadSelectors;

    public TargetFluentImpl(){
    }
    public TargetFluentImpl(me.snowdrop.istio.api.rbac.v1alpha1.Target instance){
            this.withNamespaces(instance.getNamespaces()); 
            this.withServices(instance.getServices()); 
            this.withWorkloadSelectors(instance.getWorkloadSelectors()); 
    }

    public A addToNamespaces(int index,String item){
            if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
            this.namespaces.add(index, item);
            return (A)this;
    }

    public A setToNamespaces(int index,String item){
            if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
            this.namespaces.set(index, item); return (A)this;
    }

    public A addToNamespaces(String... items){
            if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
            for (String item : items) {this.namespaces.add(item);} return (A)this;
    }

    public A addAllToNamespaces(Collection<String> items){
            if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
            for (String item : items) {this.namespaces.add(item);} return (A)this;
    }

    public A removeFromNamespaces(String... items){
            for (String item : items) {if (this.namespaces!= null){ this.namespaces.remove(item);}} return (A)this;
    }

    public A removeAllFromNamespaces(Collection<String> items){
            for (String item : items) {if (this.namespaces!= null){ this.namespaces.remove(item);}} return (A)this;
    }

    public List<String> getNamespaces(){
            return this.namespaces;
    }

    public String getNamespace(int index){
            return this.namespaces.get(index);
    }

    public String getFirstNamespace(){
            return this.namespaces.get(0);
    }

    public String getLastNamespace(){
            return this.namespaces.get(namespaces.size() - 1);
    }

    public String getMatchingNamespace(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: namespaces) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingNamespace(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: namespaces) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withNamespaces(List<String> namespaces){
            if (this.namespaces != null) { _visitables.get("namespaces").removeAll(this.namespaces);}
            if (namespaces != null) {this.namespaces = new ArrayList<String>(); for (String item : namespaces){this.addToNamespaces(item);}} else { this.namespaces = null;} return (A) this;
    }

    public A withNamespaces(String... namespaces){
            if (this.namespaces != null) {this.namespaces.clear();}
            if (namespaces != null) {for (String item :namespaces){ this.addToNamespaces(item);}} return (A) this;
    }

    public Boolean hasNamespaces(){
            return namespaces != null && !namespaces.isEmpty();
    }

    public A addNewNamespace(String arg1){
            return (A)addToNamespaces(new String(arg1));
    }

    public A addNewNamespace(StringBuilder arg1){
            return (A)addToNamespaces(new String(arg1));
    }

    public A addNewNamespace(StringBuffer arg1){
            return (A)addToNamespaces(new String(arg1));
    }

    public A addToServices(int index,String item){
            if (this.services == null) {this.services = new ArrayList<String>();}
            this.services.add(index, item);
            return (A)this;
    }

    public A setToServices(int index,String item){
            if (this.services == null) {this.services = new ArrayList<String>();}
            this.services.set(index, item); return (A)this;
    }

    public A addToServices(String... items){
            if (this.services == null) {this.services = new ArrayList<String>();}
            for (String item : items) {this.services.add(item);} return (A)this;
    }

    public A addAllToServices(Collection<String> items){
            if (this.services == null) {this.services = new ArrayList<String>();}
            for (String item : items) {this.services.add(item);} return (A)this;
    }

    public A removeFromServices(String... items){
            for (String item : items) {if (this.services!= null){ this.services.remove(item);}} return (A)this;
    }

    public A removeAllFromServices(Collection<String> items){
            for (String item : items) {if (this.services!= null){ this.services.remove(item);}} return (A)this;
    }

    public List<String> getServices(){
            return this.services;
    }

    public String getService(int index){
            return this.services.get(index);
    }

    public String getFirstService(){
            return this.services.get(0);
    }

    public String getLastService(){
            return this.services.get(services.size() - 1);
    }

    public String getMatchingService(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: services) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingService(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: services) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withServices(List<String> services){
            if (this.services != null) { _visitables.get("services").removeAll(this.services);}
            if (services != null) {this.services = new ArrayList<String>(); for (String item : services){this.addToServices(item);}} else { this.services = null;} return (A) this;
    }

    public A withServices(String... services){
            if (this.services != null) {this.services.clear();}
            if (services != null) {for (String item :services){ this.addToServices(item);}} return (A) this;
    }

    public Boolean hasServices(){
            return services != null && !services.isEmpty();
    }

    public A addNewService(String arg1){
            return (A)addToServices(new String(arg1));
    }

    public A addNewService(StringBuilder arg1){
            return (A)addToServices(new String(arg1));
    }

    public A addNewService(StringBuffer arg1){
            return (A)addToServices(new String(arg1));
    }

    public A addToWorkloadSelectors(int index,me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelector item){
            if (this.workloadSelectors == null) {this.workloadSelectors = new ArrayList<me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelectorBuilder>();}
            me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelectorBuilder builder = new me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelectorBuilder(item);_visitables.get("workloadSelectors").add(index >= 0 ? index : _visitables.get("workloadSelectors").size(), builder);this.workloadSelectors.add(index >= 0 ? index : workloadSelectors.size(), builder); return (A)this;
    }

    public A setToWorkloadSelectors(int index,me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelector item){
            if (this.workloadSelectors == null) {this.workloadSelectors = new ArrayList<me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelectorBuilder>();}
            me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelectorBuilder builder = new me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelectorBuilder(item);
            if (index < 0 || index >= _visitables.get("workloadSelectors").size()) { _visitables.get("workloadSelectors").add(builder); } else { _visitables.get("workloadSelectors").set(index, builder);}
            if (index < 0 || index >= workloadSelectors.size()) { workloadSelectors.add(builder); } else { workloadSelectors.set(index, builder);}
             return (A)this;
    }

    public A addToWorkloadSelectors(me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelector... items){
            if (this.workloadSelectors == null) {this.workloadSelectors = new ArrayList<me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelectorBuilder>();}
            for (me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelector item : items) {me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelectorBuilder builder = new me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelectorBuilder(item);_visitables.get("workloadSelectors").add(builder);this.workloadSelectors.add(builder);} return (A)this;
    }

    public A addAllToWorkloadSelectors(Collection<me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelector> items){
            if (this.workloadSelectors == null) {this.workloadSelectors = new ArrayList<me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelectorBuilder>();}
            for (me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelector item : items) {me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelectorBuilder builder = new me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelectorBuilder(item);_visitables.get("workloadSelectors").add(builder);this.workloadSelectors.add(builder);} return (A)this;
    }

    public A removeFromWorkloadSelectors(me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelector... items){
            for (me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelector item : items) {me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelectorBuilder builder = new me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelectorBuilder(item);_visitables.get("workloadSelectors").remove(builder);if (this.workloadSelectors != null) {this.workloadSelectors.remove(builder);}} return (A)this;
    }

    public A removeAllFromWorkloadSelectors(Collection<me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelector> items){
            for (me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelector item : items) {me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelectorBuilder builder = new me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelectorBuilder(item);_visitables.get("workloadSelectors").remove(builder);if (this.workloadSelectors != null) {this.workloadSelectors.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromWorkloadSelectors(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelectorBuilder> predicate){
            if (workloadSelectors == null) return (A) this;
            final Iterator<me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelectorBuilder> each = workloadSelectors.iterator();
            final List visitables = _visitables.get("workloadSelectors");
            while (each.hasNext()) {
              me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelectorBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildWorkloadSelectors instead.
 * @return The buildable object.
 */
@Deprecated public List<me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelector> getWorkloadSelectors(){
            return build(workloadSelectors);
    }

    public List<me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelector> buildWorkloadSelectors(){
            return build(workloadSelectors);
    }

    public me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelector buildWorkloadSelector(int index){
            return this.workloadSelectors.get(index).build();
    }

    public me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelector buildFirstWorkloadSelector(){
            return this.workloadSelectors.get(0).build();
    }

    public me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelector buildLastWorkloadSelector(){
            return this.workloadSelectors.get(workloadSelectors.size() - 1).build();
    }

    public me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelector buildMatchingWorkloadSelector(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelectorBuilder> predicate){
            for (me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelectorBuilder item: workloadSelectors) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingWorkloadSelector(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelectorBuilder> predicate){
            for (me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelectorBuilder item: workloadSelectors) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withWorkloadSelectors(List<me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelector> workloadSelectors){
            if (this.workloadSelectors != null) { _visitables.get("workloadSelectors").removeAll(this.workloadSelectors);}
            if (workloadSelectors != null) {this.workloadSelectors = new ArrayList<me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelectorBuilder>(); for (me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelector item : workloadSelectors){this.addToWorkloadSelectors(item);}} else { this.workloadSelectors = null;} return (A) this;
    }

    public A withWorkloadSelectors(me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelector... workloadSelectors){
            if (this.workloadSelectors != null) {this.workloadSelectors.clear();}
            if (workloadSelectors != null) {for (me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelector item :workloadSelectors){ this.addToWorkloadSelectors(item);}} return (A) this;
    }

    public Boolean hasWorkloadSelectors(){
            return workloadSelectors != null && !workloadSelectors.isEmpty();
    }

    public TargetFluent.WorkloadSelectorsNested<A> addNewWorkloadSelector(){
            return new WorkloadSelectorsNestedImpl();
    }

    public TargetFluent.WorkloadSelectorsNested<A> addNewWorkloadSelectorLike(me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelector item){
            return new WorkloadSelectorsNestedImpl(-1, item);
    }

    public TargetFluent.WorkloadSelectorsNested<A> setNewWorkloadSelectorLike(int index,me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelector item){
            return new WorkloadSelectorsNestedImpl(index, item);
    }

    public TargetFluent.WorkloadSelectorsNested<A> editWorkloadSelector(int index){
            if (workloadSelectors.size() <= index) throw new RuntimeException("Can't edit workloadSelectors. Index exceeds size.");
            return setNewWorkloadSelectorLike(index, buildWorkloadSelector(index));
    }

    public TargetFluent.WorkloadSelectorsNested<A> editFirstWorkloadSelector(){
            if (workloadSelectors.size() == 0) throw new RuntimeException("Can't edit first workloadSelectors. The list is empty.");
            return setNewWorkloadSelectorLike(0, buildWorkloadSelector(0));
    }

    public TargetFluent.WorkloadSelectorsNested<A> editLastWorkloadSelector(){
            int index = workloadSelectors.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last workloadSelectors. The list is empty.");
            return setNewWorkloadSelectorLike(index, buildWorkloadSelector(index));
    }

    public TargetFluent.WorkloadSelectorsNested<A> editMatchingWorkloadSelector(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelectorBuilder> predicate){
            int index = -1;
            for (int i=0;i<workloadSelectors.size();i++) { 
            if (predicate.apply(workloadSelectors.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching workloadSelectors. No match found.");
            return setNewWorkloadSelectorLike(index, buildWorkloadSelector(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            TargetFluentImpl that = (TargetFluentImpl) o;
            if (namespaces != null ? !namespaces.equals(that.namespaces) :that.namespaces != null) return false;
            if (services != null ? !services.equals(that.services) :that.services != null) return false;
            if (workloadSelectors != null ? !workloadSelectors.equals(that.workloadSelectors) :that.workloadSelectors != null) return false;
            return true;
    }


    public class WorkloadSelectorsNestedImpl<N> extends me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelectorFluentImpl<TargetFluent.WorkloadSelectorsNested<N>> implements TargetFluent.WorkloadSelectorsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelectorBuilder builder;
        private final int index;
    
            WorkloadSelectorsNestedImpl(int index,me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelector item){
                    this.index = index;
                    this.builder = new me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelectorBuilder(this, item);
            }
            WorkloadSelectorsNestedImpl(){
                    this.index = -1;
                    this.builder = new me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelectorBuilder(this);
            }
    
    public N and(){
            return (N) TargetFluentImpl.this.setToWorkloadSelectors(index, builder.build());
    }
    public N endWorkloadSelector(){
            return and();
    }

}


}
