package me.snowdrop.istio.mixer.adapter.circonus;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Boolean;

public interface CirconusFluent<A extends CirconusFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public CirconusFluent.MetadataNested<A> withNewMetadata();
    public CirconusFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public CirconusFluent.MetadataNested<A> editMetadata();
    public CirconusFluent.MetadataNested<A> editOrNewMetadata();
    public CirconusFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public CirconusSpec getSpec();
    public CirconusSpec buildSpec();
    public A withSpec(CirconusSpec spec);
    public Boolean hasSpec();
    public CirconusFluent.SpecNested<A> withNewSpec();
    public CirconusFluent.SpecNested<A> withNewSpecLike(CirconusSpec item);
    public CirconusFluent.SpecNested<A> editSpec();
    public CirconusFluent.SpecNested<A> editOrNewSpec();
    public CirconusFluent.SpecNested<A> editOrNewSpecLike(CirconusSpec item);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<CirconusFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,CirconusSpecFluent<CirconusFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}


}
