package me.snowdrop.istio.mixer.adapter.circonus;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface CirconusListFluent<A extends CirconusListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,Circonus item);
    public A setToItems(int index,Circonus item);
    public A addToItems(Circonus... items);
    public A addAllToItems(Collection<Circonus> items);
    public A removeFromItems(Circonus... items);
    public A removeAllFromItems(Collection<Circonus> items);
    public A removeMatchingFromItems(Predicate<CirconusBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Circonus> getItems();
    public List<Circonus> buildItems();
    public Circonus buildItem(int index);
    public Circonus buildFirstItem();
    public Circonus buildLastItem();
    public Circonus buildMatchingItem(Predicate<CirconusBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<CirconusBuilder> predicate);
    public A withItems(List<Circonus> items);
    public A withItems(Circonus... items);
    public Boolean hasItems();
    public CirconusListFluent.ItemsNested<A> addNewItem();
    public CirconusListFluent.ItemsNested<A> addNewItemLike(Circonus item);
    public CirconusListFluent.ItemsNested<A> setNewItemLike(int index,Circonus item);
    public CirconusListFluent.ItemsNested<A> editItem(int index);
    public CirconusListFluent.ItemsNested<A> editFirstItem();
    public CirconusListFluent.ItemsNested<A> editLastItem();
    public CirconusListFluent.ItemsNested<A> editMatchingItem(Predicate<CirconusBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,CirconusFluent<CirconusListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
