package me.snowdrop.istio.mixer.adapter.cloudwatch;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Boolean;

public interface CloudwatchFluent<A extends CloudwatchFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public CloudwatchFluent.MetadataNested<A> withNewMetadata();
    public CloudwatchFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public CloudwatchFluent.MetadataNested<A> editMetadata();
    public CloudwatchFluent.MetadataNested<A> editOrNewMetadata();
    public CloudwatchFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public CloudwatchSpec getSpec();
    public CloudwatchSpec buildSpec();
    public A withSpec(CloudwatchSpec spec);
    public Boolean hasSpec();
    public CloudwatchFluent.SpecNested<A> withNewSpec();
    public CloudwatchFluent.SpecNested<A> withNewSpecLike(CloudwatchSpec item);
    public CloudwatchFluent.SpecNested<A> editSpec();
    public CloudwatchFluent.SpecNested<A> editOrNewSpec();
    public CloudwatchFluent.SpecNested<A> editOrNewSpecLike(CloudwatchSpec item);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<CloudwatchFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,CloudwatchSpecFluent<CloudwatchFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}


}
