package me.snowdrop.istio.mixer.adapter.cloudwatch;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CloudwatchListBuilder extends CloudwatchListFluentImpl<CloudwatchListBuilder> implements VisitableBuilder<CloudwatchList,CloudwatchListBuilder>{

    CloudwatchListFluent<?> fluent;
    Boolean validationEnabled;

    public CloudwatchListBuilder(){
            this(true);
    }
    public CloudwatchListBuilder(Boolean validationEnabled){
            this(new CloudwatchList(), validationEnabled);
    }
    public CloudwatchListBuilder(CloudwatchListFluent<?> fluent){
            this(fluent, true);
    }
    public CloudwatchListBuilder(CloudwatchListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new CloudwatchList(), validationEnabled);
    }
    public CloudwatchListBuilder(CloudwatchListFluent<?> fluent,CloudwatchList instance){
            this(fluent, instance, true);
    }
    public CloudwatchListBuilder(CloudwatchListFluent<?> fluent,CloudwatchList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public CloudwatchListBuilder(CloudwatchList instance){
            this(instance,true);
    }
    public CloudwatchListBuilder(CloudwatchList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public CloudwatchList build(){
            CloudwatchList buildable = new CloudwatchList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CloudwatchListBuilder that = (CloudwatchListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
