package me.snowdrop.istio.mixer.adapter.cloudwatch;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface CloudwatchListFluent<A extends CloudwatchListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,Cloudwatch item);
    public A setToItems(int index,Cloudwatch item);
    public A addToItems(Cloudwatch... items);
    public A addAllToItems(Collection<Cloudwatch> items);
    public A removeFromItems(Cloudwatch... items);
    public A removeAllFromItems(Collection<Cloudwatch> items);
    public A removeMatchingFromItems(Predicate<CloudwatchBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Cloudwatch> getItems();
    public List<Cloudwatch> buildItems();
    public Cloudwatch buildItem(int index);
    public Cloudwatch buildFirstItem();
    public Cloudwatch buildLastItem();
    public Cloudwatch buildMatchingItem(Predicate<CloudwatchBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<CloudwatchBuilder> predicate);
    public A withItems(List<Cloudwatch> items);
    public A withItems(Cloudwatch... items);
    public Boolean hasItems();
    public CloudwatchListFluent.ItemsNested<A> addNewItem();
    public CloudwatchListFluent.ItemsNested<A> addNewItemLike(Cloudwatch item);
    public CloudwatchListFluent.ItemsNested<A> setNewItemLike(int index,Cloudwatch item);
    public CloudwatchListFluent.ItemsNested<A> editItem(int index);
    public CloudwatchListFluent.ItemsNested<A> editFirstItem();
    public CloudwatchListFluent.ItemsNested<A> editLastItem();
    public CloudwatchListFluent.ItemsNested<A> editMatchingItem(Predicate<CloudwatchBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,CloudwatchFluent<CloudwatchListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
