
package me.snowdrop.istio.mixer.adapter.cloudwatch;

import java.io.Serializable;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "logGroupName",
    "logStreamName",
    "logs",
    "metricInfo",
    "namespace"
})
@IstioKind(name = "cloudwatch", plural = "cloudwatches")
@IstioApiVersion("config.istio.io/v1alpha2")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class CloudwatchSpec implements Serializable, IstioSpec
{

    /**
     * 
     * 
     */
    @JsonProperty("logGroupName")
    @JsonPropertyDescription("")
    private java.lang.String logGroupName;
    /**
     * 
     * 
     */
    @JsonProperty("logStreamName")
    @JsonPropertyDescription("")
    private java.lang.String logStreamName;
    /**
     * 
     * 
     */
    @JsonProperty("logs")
    @JsonPropertyDescription("")
    private Map<String, LogInfo> logs;
    /**
     * 
     * 
     */
    @JsonProperty("metricInfo")
    @JsonPropertyDescription("")
    private Map<String, MetricDatum> metricInfo;
    /**
     * 
     * 
     */
    @JsonProperty("namespace")
    @JsonPropertyDescription("")
    private java.lang.String namespace;
    private final static long serialVersionUID = -1457607314223032064L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public CloudwatchSpec() {
    }

    /**
     * 
     * @param logGroupName
     * @param logStreamName
     * @param metricInfo
     * @param namespace
     * @param logs
     */
    public CloudwatchSpec(java.lang.String logGroupName, java.lang.String logStreamName, Map<String, LogInfo> logs, Map<String, MetricDatum> metricInfo, java.lang.String namespace) {
        super();
        this.logGroupName = logGroupName;
        this.logStreamName = logStreamName;
        this.logs = logs;
        this.metricInfo = metricInfo;
        this.namespace = namespace;
    }

    /**
     * 
     * 
     */
    @JsonProperty("logGroupName")
    public java.lang.String getLogGroupName() {
        return logGroupName;
    }

    /**
     * 
     * 
     */
    @JsonProperty("logGroupName")
    public void setLogGroupName(java.lang.String logGroupName) {
        this.logGroupName = logGroupName;
    }

    /**
     * 
     * 
     */
    @JsonProperty("logStreamName")
    public java.lang.String getLogStreamName() {
        return logStreamName;
    }

    /**
     * 
     * 
     */
    @JsonProperty("logStreamName")
    public void setLogStreamName(java.lang.String logStreamName) {
        this.logStreamName = logStreamName;
    }

    /**
     * 
     * 
     */
    @JsonProperty("logs")
    public Map<String, LogInfo> getLogs() {
        return logs;
    }

    /**
     * 
     * 
     */
    @JsonProperty("logs")
    public void setLogs(Map<String, LogInfo> logs) {
        this.logs = logs;
    }

    /**
     * 
     * 
     */
    @JsonProperty("metricInfo")
    public Map<String, MetricDatum> getMetricInfo() {
        return metricInfo;
    }

    /**
     * 
     * 
     */
    @JsonProperty("metricInfo")
    public void setMetricInfo(Map<String, MetricDatum> metricInfo) {
        this.metricInfo = metricInfo;
    }

    /**
     * 
     * 
     */
    @JsonProperty("namespace")
    public java.lang.String getNamespace() {
        return namespace;
    }

    /**
     * 
     * 
     */
    @JsonProperty("namespace")
    public void setNamespace(java.lang.String namespace) {
        this.namespace = namespace;
    }

}
