package me.snowdrop.istio.mixer.adapter.cloudwatch;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CloudwatchSpecBuilder extends CloudwatchSpecFluentImpl<CloudwatchSpecBuilder> implements VisitableBuilder<CloudwatchSpec,CloudwatchSpecBuilder>{

    CloudwatchSpecFluent<?> fluent;
    Boolean validationEnabled;

    public CloudwatchSpecBuilder(){
            this(true);
    }
    public CloudwatchSpecBuilder(Boolean validationEnabled){
            this(new CloudwatchSpec(), validationEnabled);
    }
    public CloudwatchSpecBuilder(CloudwatchSpecFluent<?> fluent){
            this(fluent, true);
    }
    public CloudwatchSpecBuilder(CloudwatchSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new CloudwatchSpec(), validationEnabled);
    }
    public CloudwatchSpecBuilder(CloudwatchSpecFluent<?> fluent,CloudwatchSpec instance){
            this(fluent, instance, true);
    }
    public CloudwatchSpecBuilder(CloudwatchSpecFluent<?> fluent,CloudwatchSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withLogGroupName(instance.getLogGroupName()); 
            fluent.withLogStreamName(instance.getLogStreamName()); 
            fluent.withLogs(instance.getLogs()); 
            fluent.withMetricInfo(instance.getMetricInfo()); 
            fluent.withNamespace(instance.getNamespace()); 
            this.validationEnabled = validationEnabled; 
    }
    public CloudwatchSpecBuilder(CloudwatchSpec instance){
            this(instance,true);
    }
    public CloudwatchSpecBuilder(CloudwatchSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withLogGroupName(instance.getLogGroupName()); 
            this.withLogStreamName(instance.getLogStreamName()); 
            this.withLogs(instance.getLogs()); 
            this.withMetricInfo(instance.getMetricInfo()); 
            this.withNamespace(instance.getNamespace()); 
            this.validationEnabled = validationEnabled; 
    }

    public CloudwatchSpec build(){
            CloudwatchSpec buildable = new CloudwatchSpec(fluent.getLogGroupName(),fluent.getLogStreamName(),fluent.getLogs(),fluent.getMetricInfo(),fluent.getNamespace());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CloudwatchSpecBuilder that = (CloudwatchSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
