package me.snowdrop.istio.mixer.adapter.cloudwatch;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class CloudwatchSpecFluentImpl<A extends CloudwatchSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CloudwatchSpecFluent<A>{

    private String logGroupName;
    private String logStreamName;
    private Map<String,LogInfo> logs;
    private Map<String,MetricDatum> metricInfo;
    private String namespace;

    public CloudwatchSpecFluentImpl(){
    }
    public CloudwatchSpecFluentImpl(CloudwatchSpec instance){
            this.withLogGroupName(instance.getLogGroupName()); 
            this.withLogStreamName(instance.getLogStreamName()); 
            this.withLogs(instance.getLogs()); 
            this.withMetricInfo(instance.getMetricInfo()); 
            this.withNamespace(instance.getNamespace()); 
    }

    public String getLogGroupName(){
            return this.logGroupName;
    }

    public A withLogGroupName(String logGroupName){
            this.logGroupName=logGroupName; return (A) this;
    }

    public Boolean hasLogGroupName(){
            return this.logGroupName != null;
    }

    public A withNewLogGroupName(String arg1){
            return (A)withLogGroupName(new String(arg1));
    }

    public A withNewLogGroupName(StringBuilder arg1){
            return (A)withLogGroupName(new String(arg1));
    }

    public A withNewLogGroupName(StringBuffer arg1){
            return (A)withLogGroupName(new String(arg1));
    }

    public String getLogStreamName(){
            return this.logStreamName;
    }

    public A withLogStreamName(String logStreamName){
            this.logStreamName=logStreamName; return (A) this;
    }

    public Boolean hasLogStreamName(){
            return this.logStreamName != null;
    }

    public A withNewLogStreamName(String arg1){
            return (A)withLogStreamName(new String(arg1));
    }

    public A withNewLogStreamName(StringBuilder arg1){
            return (A)withLogStreamName(new String(arg1));
    }

    public A withNewLogStreamName(StringBuffer arg1){
            return (A)withLogStreamName(new String(arg1));
    }

    public A addToLogs(String key,LogInfo value){
            if(this.logs == null && key != null && value != null) { this.logs = new LinkedHashMap<String,LogInfo>(); }
            if(key != null && value != null) {this.logs.put(key, value);} return (A)this;
    }

    public A addToLogs(Map<String,LogInfo> map){
            if(this.logs == null && map != null) { this.logs = new LinkedHashMap<String,LogInfo>(); }
            if(map != null) { this.logs.putAll(map);} return (A)this;
    }

    public A removeFromLogs(String key){
            if(this.logs == null) { return (A) this; }
            if(key != null && this.logs != null) {this.logs.remove(key);} return (A)this;
    }

    public A removeFromLogs(Map<String,LogInfo> map){
            if(this.logs == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.logs != null){this.logs.remove(key);}}} return (A)this;
    }

    public Map<String,LogInfo> getLogs(){
            return this.logs;
    }

    public A withLogs(Map<String,LogInfo> logs){
            if (logs == null) { this.logs =  null;} else {this.logs = new LinkedHashMap<String,LogInfo>(logs);} return (A) this;
    }

    public Boolean hasLogs(){
            return this.logs != null;
    }

    public A addToMetricInfo(String key,MetricDatum value){
            if(this.metricInfo == null && key != null && value != null) { this.metricInfo = new LinkedHashMap<String,MetricDatum>(); }
            if(key != null && value != null) {this.metricInfo.put(key, value);} return (A)this;
    }

    public A addToMetricInfo(Map<String,MetricDatum> map){
            if(this.metricInfo == null && map != null) { this.metricInfo = new LinkedHashMap<String,MetricDatum>(); }
            if(map != null) { this.metricInfo.putAll(map);} return (A)this;
    }

    public A removeFromMetricInfo(String key){
            if(this.metricInfo == null) { return (A) this; }
            if(key != null && this.metricInfo != null) {this.metricInfo.remove(key);} return (A)this;
    }

    public A removeFromMetricInfo(Map<String,MetricDatum> map){
            if(this.metricInfo == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.metricInfo != null){this.metricInfo.remove(key);}}} return (A)this;
    }

    public Map<String,MetricDatum> getMetricInfo(){
            return this.metricInfo;
    }

    public A withMetricInfo(Map<String,MetricDatum> metricInfo){
            if (metricInfo == null) { this.metricInfo =  null;} else {this.metricInfo = new LinkedHashMap<String,MetricDatum>(metricInfo);} return (A) this;
    }

    public Boolean hasMetricInfo(){
            return this.metricInfo != null;
    }

    public String getNamespace(){
            return this.namespace;
    }

    public A withNamespace(String namespace){
            this.namespace=namespace; return (A) this;
    }

    public Boolean hasNamespace(){
            return this.namespace != null;
    }

    public A withNewNamespace(String arg1){
            return (A)withNamespace(new String(arg1));
    }

    public A withNewNamespace(StringBuilder arg1){
            return (A)withNamespace(new String(arg1));
    }

    public A withNewNamespace(StringBuffer arg1){
            return (A)withNamespace(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            CloudwatchSpecFluentImpl that = (CloudwatchSpecFluentImpl) o;
            if (logGroupName != null ? !logGroupName.equals(that.logGroupName) :that.logGroupName != null) return false;
            if (logStreamName != null ? !logStreamName.equals(that.logStreamName) :that.logStreamName != null) return false;
            if (logs != null ? !logs.equals(that.logs) :that.logs != null) return false;
            if (metricInfo != null ? !metricInfo.equals(that.metricInfo) :that.metricInfo != null) return false;
            if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
            return true;
    }




}
