package me.snowdrop.istio.mixer.adapter.denier;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DenierListBuilder extends DenierListFluentImpl<DenierListBuilder> implements VisitableBuilder<DenierList,DenierListBuilder>{

    DenierListFluent<?> fluent;
    Boolean validationEnabled;

    public DenierListBuilder(){
            this(true);
    }
    public DenierListBuilder(Boolean validationEnabled){
            this(new DenierList(), validationEnabled);
    }
    public DenierListBuilder(DenierListFluent<?> fluent){
            this(fluent, true);
    }
    public DenierListBuilder(DenierListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new DenierList(), validationEnabled);
    }
    public DenierListBuilder(DenierListFluent<?> fluent,DenierList instance){
            this(fluent, instance, true);
    }
    public DenierListBuilder(DenierListFluent<?> fluent,DenierList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public DenierListBuilder(DenierList instance){
            this(instance,true);
    }
    public DenierListBuilder(DenierList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public DenierList build(){
            DenierList buildable = new DenierList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DenierListBuilder that = (DenierListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
