package me.snowdrop.istio.mixer.adapter.denier;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DenierSpecBuilder extends DenierSpecFluentImpl<DenierSpecBuilder> implements VisitableBuilder<DenierSpec,DenierSpecBuilder>{

    DenierSpecFluent<?> fluent;
    Boolean validationEnabled;

    public DenierSpecBuilder(){
            this(true);
    }
    public DenierSpecBuilder(Boolean validationEnabled){
            this(new DenierSpec(), validationEnabled);
    }
    public DenierSpecBuilder(DenierSpecFluent<?> fluent){
            this(fluent, true);
    }
    public DenierSpecBuilder(DenierSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new DenierSpec(), validationEnabled);
    }
    public DenierSpecBuilder(DenierSpecFluent<?> fluent,DenierSpec instance){
            this(fluent, instance, true);
    }
    public DenierSpecBuilder(DenierSpecFluent<?> fluent,DenierSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withStatus(instance.getStatus()); 
            fluent.withValidDuration(instance.getValidDuration()); 
            fluent.withValidUseCount(instance.getValidUseCount()); 
            this.validationEnabled = validationEnabled; 
    }
    public DenierSpecBuilder(DenierSpec instance){
            this(instance,true);
    }
    public DenierSpecBuilder(DenierSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withStatus(instance.getStatus()); 
            this.withValidDuration(instance.getValidDuration()); 
            this.withValidUseCount(instance.getValidUseCount()); 
            this.validationEnabled = validationEnabled; 
    }

    public DenierSpec build(){
            DenierSpec buildable = new DenierSpec(fluent.getStatus(),fluent.getValidDuration(),fluent.getValidUseCount());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DenierSpecBuilder that = (DenierSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
