package me.snowdrop.istio.mixer.adapter.dogstatsd;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DogstatsdBuilder extends DogstatsdFluentImpl<DogstatsdBuilder> implements VisitableBuilder<Dogstatsd,DogstatsdBuilder>{

    DogstatsdFluent<?> fluent;
    Boolean validationEnabled;

    public DogstatsdBuilder(){
            this(true);
    }
    public DogstatsdBuilder(Boolean validationEnabled){
            this(new Dogstatsd(), validationEnabled);
    }
    public DogstatsdBuilder(DogstatsdFluent<?> fluent){
            this(fluent, true);
    }
    public DogstatsdBuilder(DogstatsdFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Dogstatsd(), validationEnabled);
    }
    public DogstatsdBuilder(DogstatsdFluent<?> fluent,Dogstatsd instance){
            this(fluent, instance, true);
    }
    public DogstatsdBuilder(DogstatsdFluent<?> fluent,Dogstatsd instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public DogstatsdBuilder(Dogstatsd instance){
            this(instance,true);
    }
    public DogstatsdBuilder(Dogstatsd instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }

    public Dogstatsd build(){
            Dogstatsd buildable = new Dogstatsd(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DogstatsdBuilder that = (DogstatsdBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
