package me.snowdrop.istio.mixer.adapter.dogstatsd;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DogstatsdListBuilder extends DogstatsdListFluentImpl<DogstatsdListBuilder> implements VisitableBuilder<DogstatsdList,DogstatsdListBuilder>{

    DogstatsdListFluent<?> fluent;
    Boolean validationEnabled;

    public DogstatsdListBuilder(){
            this(true);
    }
    public DogstatsdListBuilder(Boolean validationEnabled){
            this(new DogstatsdList(), validationEnabled);
    }
    public DogstatsdListBuilder(DogstatsdListFluent<?> fluent){
            this(fluent, true);
    }
    public DogstatsdListBuilder(DogstatsdListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new DogstatsdList(), validationEnabled);
    }
    public DogstatsdListBuilder(DogstatsdListFluent<?> fluent,DogstatsdList instance){
            this(fluent, instance, true);
    }
    public DogstatsdListBuilder(DogstatsdListFluent<?> fluent,DogstatsdList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public DogstatsdListBuilder(DogstatsdList instance){
            this(instance,true);
    }
    public DogstatsdListBuilder(DogstatsdList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public DogstatsdList build(){
            DogstatsdList buildable = new DogstatsdList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DogstatsdListBuilder that = (DogstatsdListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
