package me.snowdrop.istio.mixer.adapter.dogstatsd;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;

public class DogstatsdListFluentImpl<A extends DogstatsdListFluent<A>> extends BaseFluent<A> implements DogstatsdListFluent<A>{

    private String apiVersion;
    private List<DogstatsdBuilder> items;
    private String kind;
    private ListMeta metadata;

    public DogstatsdListFluentImpl(){
    }
    public DogstatsdListFluentImpl(DogstatsdList instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A addToItems(int index,Dogstatsd item){
            if (this.items == null) {this.items = new ArrayList<DogstatsdBuilder>();}
            DogstatsdBuilder builder = new DogstatsdBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToItems(int index,Dogstatsd item){
            if (this.items == null) {this.items = new ArrayList<DogstatsdBuilder>();}
            DogstatsdBuilder builder = new DogstatsdBuilder(item);
            if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToItems(Dogstatsd... items){
            if (this.items == null) {this.items = new ArrayList<DogstatsdBuilder>();}
            for (Dogstatsd item : items) {DogstatsdBuilder builder = new DogstatsdBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToItems(Collection<Dogstatsd> items){
            if (this.items == null) {this.items = new ArrayList<DogstatsdBuilder>();}
            for (Dogstatsd item : items) {DogstatsdBuilder builder = new DogstatsdBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(Dogstatsd... items){
            for (Dogstatsd item : items) {DogstatsdBuilder builder = new DogstatsdBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromItems(Collection<Dogstatsd> items){
            for (Dogstatsd item : items) {DogstatsdBuilder builder = new DogstatsdBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromItems(Predicate<DogstatsdBuilder> predicate){
            if (items == null) return (A) this;
            final Iterator<DogstatsdBuilder> each = items.iterator();
            final List visitables = _visitables.get("items");
            while (each.hasNext()) {
              DogstatsdBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Dogstatsd> getItems(){
            return build(items);
    }

    public List<Dogstatsd> buildItems(){
            return build(items);
    }

    public Dogstatsd buildItem(int index){
            return this.items.get(index).build();
    }

    public Dogstatsd buildFirstItem(){
            return this.items.get(0).build();
    }

    public Dogstatsd buildLastItem(){
            return this.items.get(items.size() - 1).build();
    }

    public Dogstatsd buildMatchingItem(Predicate<DogstatsdBuilder> predicate){
            for (DogstatsdBuilder item: items) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingItem(Predicate<DogstatsdBuilder> predicate){
            for (DogstatsdBuilder item: items) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withItems(List<Dogstatsd> items){
            if (this.items != null) { _visitables.get("items").removeAll(this.items);}
            if (items != null) {this.items = new ArrayList<DogstatsdBuilder>(); for (Dogstatsd item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
    }

    public A withItems(Dogstatsd... items){
            if (this.items != null) {this.items.clear();}
            if (items != null) {for (Dogstatsd item :items){ this.addToItems(item);}} return (A) this;
    }

    public Boolean hasItems(){
            return items != null && !items.isEmpty();
    }

    public DogstatsdListFluent.ItemsNested<A> addNewItem(){
            return new ItemsNestedImpl();
    }

    public DogstatsdListFluent.ItemsNested<A> addNewItemLike(Dogstatsd item){
            return new ItemsNestedImpl(-1, item);
    }

    public DogstatsdListFluent.ItemsNested<A> setNewItemLike(int index,Dogstatsd item){
            return new ItemsNestedImpl(index, item);
    }

    public DogstatsdListFluent.ItemsNested<A> editItem(int index){
            if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
            return setNewItemLike(index, buildItem(index));
    }

    public DogstatsdListFluent.ItemsNested<A> editFirstItem(){
            if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
            return setNewItemLike(0, buildItem(0));
    }

    public DogstatsdListFluent.ItemsNested<A> editLastItem(){
            int index = items.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
            return setNewItemLike(index, buildItem(index));
    }

    public DogstatsdListFluent.ItemsNested<A> editMatchingItem(Predicate<DogstatsdBuilder> predicate){
            int index = -1;
            for (int i=0;i<items.size();i++) { 
            if (predicate.apply(items.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
            return setNewItemLike(index, buildItem(index));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    public ListMeta getMetadata(){
            return this.metadata;
    }

    public A withMetadata(ListMeta metadata){
            this.metadata=metadata; return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink){
            return (A)withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            DogstatsdListFluentImpl that = (DogstatsdListFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            return true;
    }


    public class ItemsNestedImpl<N> extends DogstatsdFluentImpl<DogstatsdListFluent.ItemsNested<N>> implements DogstatsdListFluent.ItemsNested<N>,Nested<N>{

            private final DogstatsdBuilder builder;
        private final int index;
    
            ItemsNestedImpl(int index,Dogstatsd item){
                    this.index = index;
                    this.builder = new DogstatsdBuilder(this, item);
            }
            ItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new DogstatsdBuilder(this);
            }
    
    public N and(){
            return (N) DogstatsdListFluentImpl.this.setToItems(index, builder.build());
    }
    public N endItem(){
            return and();
    }

}


}
