
package me.snowdrop.istio.mixer.adapter.dogstatsd;

import java.io.Serializable;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "address",
    "bufferLength",
    "globalTags",
    "metrics",
    "prefix",
    "sampleRate"
})
@IstioKind(name = "dogstatsd", plural = "dogstatsds")
@IstioApiVersion("config.istio.io/v1alpha2")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class DogstatsdSpec implements Serializable, IstioSpec
{

    /**
     * 
     * 
     */
    @JsonProperty("address")
    @JsonPropertyDescription("")
    private java.lang.String address;
    /**
     * 
     * 
     */
    @JsonProperty("bufferLength")
    @JsonPropertyDescription("")
    private Integer bufferLength;
    /**
     * 
     * 
     */
    @JsonProperty("globalTags")
    @JsonPropertyDescription("")
    private Map<String, String> globalTags;
    /**
     * 
     * 
     */
    @JsonProperty("metrics")
    @JsonPropertyDescription("")
    private Map<String, MetricInfo> metrics;
    /**
     * 
     * 
     */
    @JsonProperty("prefix")
    @JsonPropertyDescription("")
    private java.lang.String prefix;
    /**
     * 
     * 
     */
    @JsonProperty("sampleRate")
    @JsonPropertyDescription("")
    private Double sampleRate;
    private final static long serialVersionUID = -8830680503060422573L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DogstatsdSpec() {
    }

    /**
     * 
     * @param address
     * @param prefix
     * @param bufferLength
     * @param metrics
     * @param globalTags
     * @param sampleRate
     */
    public DogstatsdSpec(java.lang.String address, Integer bufferLength, Map<String, String> globalTags, Map<String, MetricInfo> metrics, java.lang.String prefix, Double sampleRate) {
        super();
        this.address = address;
        this.bufferLength = bufferLength;
        this.globalTags = globalTags;
        this.metrics = metrics;
        this.prefix = prefix;
        this.sampleRate = sampleRate;
    }

    /**
     * 
     * 
     */
    @JsonProperty("address")
    public java.lang.String getAddress() {
        return address;
    }

    /**
     * 
     * 
     */
    @JsonProperty("address")
    public void setAddress(java.lang.String address) {
        this.address = address;
    }

    /**
     * 
     * 
     */
    @JsonProperty("bufferLength")
    public Integer getBufferLength() {
        return bufferLength;
    }

    /**
     * 
     * 
     */
    @JsonProperty("bufferLength")
    public void setBufferLength(Integer bufferLength) {
        this.bufferLength = bufferLength;
    }

    /**
     * 
     * 
     */
    @JsonProperty("globalTags")
    public Map<String, String> getGlobalTags() {
        return globalTags;
    }

    /**
     * 
     * 
     */
    @JsonProperty("globalTags")
    public void setGlobalTags(Map<String, String> globalTags) {
        this.globalTags = globalTags;
    }

    /**
     * 
     * 
     */
    @JsonProperty("metrics")
    public Map<String, MetricInfo> getMetrics() {
        return metrics;
    }

    /**
     * 
     * 
     */
    @JsonProperty("metrics")
    public void setMetrics(Map<String, MetricInfo> metrics) {
        this.metrics = metrics;
    }

    /**
     * 
     * 
     */
    @JsonProperty("prefix")
    public java.lang.String getPrefix() {
        return prefix;
    }

    /**
     * 
     * 
     */
    @JsonProperty("prefix")
    public void setPrefix(java.lang.String prefix) {
        this.prefix = prefix;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sampleRate")
    public Double getSampleRate() {
        return sampleRate;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sampleRate")
    public void setSampleRate(Double sampleRate) {
        this.sampleRate = sampleRate;
    }

}
