package me.snowdrop.istio.mixer.adapter.dogstatsd;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DogstatsdSpecBuilder extends DogstatsdSpecFluentImpl<DogstatsdSpecBuilder> implements VisitableBuilder<DogstatsdSpec,DogstatsdSpecBuilder>{

    DogstatsdSpecFluent<?> fluent;
    Boolean validationEnabled;

    public DogstatsdSpecBuilder(){
            this(true);
    }
    public DogstatsdSpecBuilder(Boolean validationEnabled){
            this(new DogstatsdSpec(), validationEnabled);
    }
    public DogstatsdSpecBuilder(DogstatsdSpecFluent<?> fluent){
            this(fluent, true);
    }
    public DogstatsdSpecBuilder(DogstatsdSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new DogstatsdSpec(), validationEnabled);
    }
    public DogstatsdSpecBuilder(DogstatsdSpecFluent<?> fluent,DogstatsdSpec instance){
            this(fluent, instance, true);
    }
    public DogstatsdSpecBuilder(DogstatsdSpecFluent<?> fluent,DogstatsdSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAddress(instance.getAddress()); 
            fluent.withBufferLength(instance.getBufferLength()); 
            fluent.withGlobalTags(instance.getGlobalTags()); 
            fluent.withMetrics(instance.getMetrics()); 
            fluent.withPrefix(instance.getPrefix()); 
            fluent.withSampleRate(instance.getSampleRate()); 
            this.validationEnabled = validationEnabled; 
    }
    public DogstatsdSpecBuilder(DogstatsdSpec instance){
            this(instance,true);
    }
    public DogstatsdSpecBuilder(DogstatsdSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAddress(instance.getAddress()); 
            this.withBufferLength(instance.getBufferLength()); 
            this.withGlobalTags(instance.getGlobalTags()); 
            this.withMetrics(instance.getMetrics()); 
            this.withPrefix(instance.getPrefix()); 
            this.withSampleRate(instance.getSampleRate()); 
            this.validationEnabled = validationEnabled; 
    }

    public DogstatsdSpec build(){
            DogstatsdSpec buildable = new DogstatsdSpec(fluent.getAddress(),fluent.getBufferLength(),fluent.getGlobalTags(),fluent.getMetrics(),fluent.getPrefix(),fluent.getSampleRate());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DogstatsdSpecBuilder that = (DogstatsdSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
