package me.snowdrop.istio.mixer.adapter.fluentd;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class FluentdListBuilder extends FluentdListFluentImpl<FluentdListBuilder> implements VisitableBuilder<FluentdList,FluentdListBuilder>{

    FluentdListFluent<?> fluent;
    Boolean validationEnabled;

    public FluentdListBuilder(){
            this(true);
    }
    public FluentdListBuilder(Boolean validationEnabled){
            this(new FluentdList(), validationEnabled);
    }
    public FluentdListBuilder(FluentdListFluent<?> fluent){
            this(fluent, true);
    }
    public FluentdListBuilder(FluentdListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new FluentdList(), validationEnabled);
    }
    public FluentdListBuilder(FluentdListFluent<?> fluent,FluentdList instance){
            this(fluent, instance, true);
    }
    public FluentdListBuilder(FluentdListFluent<?> fluent,FluentdList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public FluentdListBuilder(FluentdList instance){
            this(instance,true);
    }
    public FluentdListBuilder(FluentdList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public FluentdList build(){
            FluentdList buildable = new FluentdList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            FluentdListBuilder that = (FluentdListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
