
package me.snowdrop.istio.mixer.adapter.fluentd;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "address",
    "instanceBufferSize",
    "integerDuration",
    "maxBatchSizeBytes",
    "pushIntervalDuration",
    "pushTimeoutDuration"
})
@IstioKind(name = "fluentd", plural = "fluentds")
@IstioApiVersion("config.istio.io/v1alpha2")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class FluentdSpec implements Serializable, IstioSpec
{

    /**
     * 
     * 
     */
    @JsonProperty("address")
    @JsonPropertyDescription("")
    private String address;
    /**
     * 
     * 
     */
    @JsonProperty("instanceBufferSize")
    @JsonPropertyDescription("")
    private Integer instanceBufferSize;
    /**
     * 
     * 
     */
    @JsonProperty("integerDuration")
    @JsonPropertyDescription("")
    private Boolean integerDuration;
    /**
     * 
     * 
     */
    @JsonProperty("maxBatchSizeBytes")
    @JsonPropertyDescription("")
    private Integer maxBatchSizeBytes;
    /**
     * 
     * 
     */
    @JsonProperty("pushIntervalDuration")
    @JsonPropertyDescription("")
    private Integer pushIntervalDuration;
    /**
     * 
     * 
     */
    @JsonProperty("pushTimeoutDuration")
    @JsonPropertyDescription("")
    private Integer pushTimeoutDuration;
    private final static long serialVersionUID = 3018244034697223415L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public FluentdSpec() {
    }

    /**
     * 
     * @param pushTimeoutDuration
     * @param address
     * @param integerDuration
     * @param maxBatchSizeBytes
     * @param instanceBufferSize
     * @param pushIntervalDuration
     */
    public FluentdSpec(String address, Integer instanceBufferSize, Boolean integerDuration, Integer maxBatchSizeBytes, Integer pushIntervalDuration, Integer pushTimeoutDuration) {
        super();
        this.address = address;
        this.instanceBufferSize = instanceBufferSize;
        this.integerDuration = integerDuration;
        this.maxBatchSizeBytes = maxBatchSizeBytes;
        this.pushIntervalDuration = pushIntervalDuration;
        this.pushTimeoutDuration = pushTimeoutDuration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("address")
    public String getAddress() {
        return address;
    }

    /**
     * 
     * 
     */
    @JsonProperty("address")
    public void setAddress(String address) {
        this.address = address;
    }

    /**
     * 
     * 
     */
    @JsonProperty("instanceBufferSize")
    public Integer getInstanceBufferSize() {
        return instanceBufferSize;
    }

    /**
     * 
     * 
     */
    @JsonProperty("instanceBufferSize")
    public void setInstanceBufferSize(Integer instanceBufferSize) {
        this.instanceBufferSize = instanceBufferSize;
    }

    /**
     * 
     * 
     */
    @JsonProperty("integerDuration")
    public Boolean getIntegerDuration() {
        return integerDuration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("integerDuration")
    public void setIntegerDuration(Boolean integerDuration) {
        this.integerDuration = integerDuration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("maxBatchSizeBytes")
    public Integer getMaxBatchSizeBytes() {
        return maxBatchSizeBytes;
    }

    /**
     * 
     * 
     */
    @JsonProperty("maxBatchSizeBytes")
    public void setMaxBatchSizeBytes(Integer maxBatchSizeBytes) {
        this.maxBatchSizeBytes = maxBatchSizeBytes;
    }

    /**
     * 
     * 
     */
    @JsonProperty("pushIntervalDuration")
    public Integer getPushIntervalDuration() {
        return pushIntervalDuration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("pushIntervalDuration")
    public void setPushIntervalDuration(Integer pushIntervalDuration) {
        this.pushIntervalDuration = pushIntervalDuration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("pushTimeoutDuration")
    public Integer getPushTimeoutDuration() {
        return pushTimeoutDuration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("pushTimeoutDuration")
    public void setPushTimeoutDuration(Integer pushTimeoutDuration) {
        this.pushTimeoutDuration = pushTimeoutDuration;
    }

}
