package me.snowdrop.istio.mixer.adapter.fluentd;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class FluentdSpecBuilder extends FluentdSpecFluentImpl<FluentdSpecBuilder> implements VisitableBuilder<FluentdSpec,FluentdSpecBuilder>{

    FluentdSpecFluent<?> fluent;
    Boolean validationEnabled;

    public FluentdSpecBuilder(){
            this(true);
    }
    public FluentdSpecBuilder(Boolean validationEnabled){
            this(new FluentdSpec(), validationEnabled);
    }
    public FluentdSpecBuilder(FluentdSpecFluent<?> fluent){
            this(fluent, true);
    }
    public FluentdSpecBuilder(FluentdSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new FluentdSpec(), validationEnabled);
    }
    public FluentdSpecBuilder(FluentdSpecFluent<?> fluent,FluentdSpec instance){
            this(fluent, instance, true);
    }
    public FluentdSpecBuilder(FluentdSpecFluent<?> fluent,FluentdSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAddress(instance.getAddress()); 
            fluent.withInstanceBufferSize(instance.getInstanceBufferSize()); 
            fluent.withIntegerDuration(instance.getIntegerDuration()); 
            fluent.withMaxBatchSizeBytes(instance.getMaxBatchSizeBytes()); 
            fluent.withPushIntervalDuration(instance.getPushIntervalDuration()); 
            fluent.withPushTimeoutDuration(instance.getPushTimeoutDuration()); 
            this.validationEnabled = validationEnabled; 
    }
    public FluentdSpecBuilder(FluentdSpec instance){
            this(instance,true);
    }
    public FluentdSpecBuilder(FluentdSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAddress(instance.getAddress()); 
            this.withInstanceBufferSize(instance.getInstanceBufferSize()); 
            this.withIntegerDuration(instance.getIntegerDuration()); 
            this.withMaxBatchSizeBytes(instance.getMaxBatchSizeBytes()); 
            this.withPushIntervalDuration(instance.getPushIntervalDuration()); 
            this.withPushTimeoutDuration(instance.getPushTimeoutDuration()); 
            this.validationEnabled = validationEnabled; 
    }

    public FluentdSpec build(){
            FluentdSpec buildable = new FluentdSpec(fluent.getAddress(),fluent.getInstanceBufferSize(),fluent.isIntegerDuration(),fluent.getMaxBatchSizeBytes(),fluent.getPushIntervalDuration(),fluent.getPushTimeoutDuration());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            FluentdSpecBuilder that = (FluentdSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
