package me.snowdrop.istio.mixer.adapter.fluentd;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class FluentdSpecFluentImpl<A extends FluentdSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements FluentdSpecFluent<A>{

    private String address;
    private Integer instanceBufferSize;
    private Boolean integerDuration;
    private Integer maxBatchSizeBytes;
    private Integer pushIntervalDuration;
    private Integer pushTimeoutDuration;

    public FluentdSpecFluentImpl(){
    }
    public FluentdSpecFluentImpl(FluentdSpec instance){
            this.withAddress(instance.getAddress()); 
            this.withInstanceBufferSize(instance.getInstanceBufferSize()); 
            this.withIntegerDuration(instance.getIntegerDuration()); 
            this.withMaxBatchSizeBytes(instance.getMaxBatchSizeBytes()); 
            this.withPushIntervalDuration(instance.getPushIntervalDuration()); 
            this.withPushTimeoutDuration(instance.getPushTimeoutDuration()); 
    }

    public String getAddress(){
            return this.address;
    }

    public A withAddress(String address){
            this.address=address; return (A) this;
    }

    public Boolean hasAddress(){
            return this.address != null;
    }

    public A withNewAddress(String arg1){
            return (A)withAddress(new String(arg1));
    }

    public A withNewAddress(StringBuilder arg1){
            return (A)withAddress(new String(arg1));
    }

    public A withNewAddress(StringBuffer arg1){
            return (A)withAddress(new String(arg1));
    }

    public Integer getInstanceBufferSize(){
            return this.instanceBufferSize;
    }

    public A withInstanceBufferSize(Integer instanceBufferSize){
            this.instanceBufferSize=instanceBufferSize; return (A) this;
    }

    public Boolean hasInstanceBufferSize(){
            return this.instanceBufferSize != null;
    }

    public Boolean isIntegerDuration(){
            return this.integerDuration;
    }

    public A withIntegerDuration(Boolean integerDuration){
            this.integerDuration=integerDuration; return (A) this;
    }

    public Boolean hasIntegerDuration(){
            return this.integerDuration != null;
    }

    public A withNewIntegerDuration(String arg1){
            return (A)withIntegerDuration(new Boolean(arg1));
    }

    public A withNewIntegerDuration(boolean arg1){
            return (A)withIntegerDuration(new Boolean(arg1));
    }

    public Integer getMaxBatchSizeBytes(){
            return this.maxBatchSizeBytes;
    }

    public A withMaxBatchSizeBytes(Integer maxBatchSizeBytes){
            this.maxBatchSizeBytes=maxBatchSizeBytes; return (A) this;
    }

    public Boolean hasMaxBatchSizeBytes(){
            return this.maxBatchSizeBytes != null;
    }

    public Integer getPushIntervalDuration(){
            return this.pushIntervalDuration;
    }

    public A withPushIntervalDuration(Integer pushIntervalDuration){
            this.pushIntervalDuration=pushIntervalDuration; return (A) this;
    }

    public Boolean hasPushIntervalDuration(){
            return this.pushIntervalDuration != null;
    }

    public Integer getPushTimeoutDuration(){
            return this.pushTimeoutDuration;
    }

    public A withPushTimeoutDuration(Integer pushTimeoutDuration){
            this.pushTimeoutDuration=pushTimeoutDuration; return (A) this;
    }

    public Boolean hasPushTimeoutDuration(){
            return this.pushTimeoutDuration != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            FluentdSpecFluentImpl that = (FluentdSpecFluentImpl) o;
            if (address != null ? !address.equals(that.address) :that.address != null) return false;
            if (instanceBufferSize != null ? !instanceBufferSize.equals(that.instanceBufferSize) :that.instanceBufferSize != null) return false;
            if (integerDuration != null ? !integerDuration.equals(that.integerDuration) :that.integerDuration != null) return false;
            if (maxBatchSizeBytes != null ? !maxBatchSizeBytes.equals(that.maxBatchSizeBytes) :that.maxBatchSizeBytes != null) return false;
            if (pushIntervalDuration != null ? !pushIntervalDuration.equals(that.pushIntervalDuration) :that.pushIntervalDuration != null) return false;
            if (pushTimeoutDuration != null ? !pushTimeoutDuration.equals(that.pushTimeoutDuration) :that.pushTimeoutDuration != null) return false;
            return true;
    }




}
