package me.snowdrop.istio.mixer.adapter.kubernetesenv;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KubernetesenvBuilder extends KubernetesenvFluentImpl<KubernetesenvBuilder> implements VisitableBuilder<Kubernetesenv,KubernetesenvBuilder>{

    KubernetesenvFluent<?> fluent;
    Boolean validationEnabled;

    public KubernetesenvBuilder(){
            this(true);
    }
    public KubernetesenvBuilder(Boolean validationEnabled){
            this(new Kubernetesenv(), validationEnabled);
    }
    public KubernetesenvBuilder(KubernetesenvFluent<?> fluent){
            this(fluent, true);
    }
    public KubernetesenvBuilder(KubernetesenvFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Kubernetesenv(), validationEnabled);
    }
    public KubernetesenvBuilder(KubernetesenvFluent<?> fluent,Kubernetesenv instance){
            this(fluent, instance, true);
    }
    public KubernetesenvBuilder(KubernetesenvFluent<?> fluent,Kubernetesenv instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public KubernetesenvBuilder(Kubernetesenv instance){
            this(instance,true);
    }
    public KubernetesenvBuilder(Kubernetesenv instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }

    public Kubernetesenv build(){
            Kubernetesenv buildable = new Kubernetesenv(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KubernetesenvBuilder that = (KubernetesenvBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
