package me.snowdrop.istio.mixer.adapter.kubernetesenv;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Boolean;

public interface KubernetesenvFluent<A extends KubernetesenvFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public KubernetesenvFluent.MetadataNested<A> withNewMetadata();
    public KubernetesenvFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public KubernetesenvFluent.MetadataNested<A> editMetadata();
    public KubernetesenvFluent.MetadataNested<A> editOrNewMetadata();
    public KubernetesenvFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public KubernetesenvSpec getSpec();
    public KubernetesenvSpec buildSpec();
    public A withSpec(KubernetesenvSpec spec);
    public Boolean hasSpec();
    public A withNewSpec(Integer cacheRefreshDuration,String clusterRegistriesNamespace,String kubeconfigPath);
    public KubernetesenvFluent.SpecNested<A> withNewSpec();
    public KubernetesenvFluent.SpecNested<A> withNewSpecLike(KubernetesenvSpec item);
    public KubernetesenvFluent.SpecNested<A> editSpec();
    public KubernetesenvFluent.SpecNested<A> editOrNewSpec();
    public KubernetesenvFluent.SpecNested<A> editOrNewSpecLike(KubernetesenvSpec item);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<KubernetesenvFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,KubernetesenvSpecFluent<KubernetesenvFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}


}
