package me.snowdrop.istio.mixer.adapter.kubernetesenv;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KubernetesenvSpecBuilder extends KubernetesenvSpecFluentImpl<KubernetesenvSpecBuilder> implements VisitableBuilder<KubernetesenvSpec,KubernetesenvSpecBuilder>{

    KubernetesenvSpecFluent<?> fluent;
    Boolean validationEnabled;

    public KubernetesenvSpecBuilder(){
            this(true);
    }
    public KubernetesenvSpecBuilder(Boolean validationEnabled){
            this(new KubernetesenvSpec(), validationEnabled);
    }
    public KubernetesenvSpecBuilder(KubernetesenvSpecFluent<?> fluent){
            this(fluent, true);
    }
    public KubernetesenvSpecBuilder(KubernetesenvSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KubernetesenvSpec(), validationEnabled);
    }
    public KubernetesenvSpecBuilder(KubernetesenvSpecFluent<?> fluent,KubernetesenvSpec instance){
            this(fluent, instance, true);
    }
    public KubernetesenvSpecBuilder(KubernetesenvSpecFluent<?> fluent,KubernetesenvSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCacheRefreshDuration(instance.getCacheRefreshDuration()); 
            fluent.withClusterRegistriesNamespace(instance.getClusterRegistriesNamespace()); 
            fluent.withKubeconfigPath(instance.getKubeconfigPath()); 
            this.validationEnabled = validationEnabled; 
    }
    public KubernetesenvSpecBuilder(KubernetesenvSpec instance){
            this(instance,true);
    }
    public KubernetesenvSpecBuilder(KubernetesenvSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCacheRefreshDuration(instance.getCacheRefreshDuration()); 
            this.withClusterRegistriesNamespace(instance.getClusterRegistriesNamespace()); 
            this.withKubeconfigPath(instance.getKubeconfigPath()); 
            this.validationEnabled = validationEnabled; 
    }

    public KubernetesenvSpec build(){
            KubernetesenvSpec buildable = new KubernetesenvSpec(fluent.getCacheRefreshDuration(),fluent.getClusterRegistriesNamespace(),fluent.getKubeconfigPath());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KubernetesenvSpecBuilder that = (KubernetesenvSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
