
package me.snowdrop.istio.mixer.adapter.list;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "blacklist",
    "cachingInterval",
    "cachingUseCount",
    "entryType",
    "overrides",
    "providerUrl",
    "refreshInterval",
    "ttl"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class BaseKubernetesList implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("blacklist")
    @JsonPropertyDescription("")
    private Boolean blacklist;
    /**
     * 
     * 
     */
    @JsonProperty("cachingInterval")
    @JsonPropertyDescription("")
    private Integer cachingInterval;
    /**
     * 
     * 
     */
    @JsonProperty("cachingUseCount")
    @JsonPropertyDescription("")
    private Integer cachingUseCount;
    @JsonProperty("entryType")
    private ListEntryType entryType;
    /**
     * 
     * 
     */
    @JsonProperty("overrides")
    @JsonPropertyDescription("")
    private List<String> overrides = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("providerUrl")
    @JsonPropertyDescription("")
    private String providerUrl;
    /**
     * 
     * 
     */
    @JsonProperty("refreshInterval")
    @JsonPropertyDescription("")
    private Integer refreshInterval;
    /**
     * 
     * 
     */
    @JsonProperty("ttl")
    @JsonPropertyDescription("")
    private Integer ttl;
    private final static long serialVersionUID = -5880604487008899426L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public BaseKubernetesList() {
    }

    /**
     * 
     * @param entryType
     * @param refreshInterval
     * @param blacklist
     * @param cachingUseCount
     * @param overrides
     * @param cachingInterval
     * @param ttl
     * @param providerUrl
     */
    public BaseKubernetesList(Boolean blacklist, Integer cachingInterval, Integer cachingUseCount, ListEntryType entryType, List<String> overrides, String providerUrl, Integer refreshInterval, Integer ttl) {
        super();
        this.blacklist = blacklist;
        this.cachingInterval = cachingInterval;
        this.cachingUseCount = cachingUseCount;
        this.entryType = entryType;
        this.overrides = overrides;
        this.providerUrl = providerUrl;
        this.refreshInterval = refreshInterval;
        this.ttl = ttl;
    }

    /**
     * 
     * 
     */
    @JsonProperty("blacklist")
    public Boolean getBlacklist() {
        return blacklist;
    }

    /**
     * 
     * 
     */
    @JsonProperty("blacklist")
    public void setBlacklist(Boolean blacklist) {
        this.blacklist = blacklist;
    }

    /**
     * 
     * 
     */
    @JsonProperty("cachingInterval")
    public Integer getCachingInterval() {
        return cachingInterval;
    }

    /**
     * 
     * 
     */
    @JsonProperty("cachingInterval")
    public void setCachingInterval(Integer cachingInterval) {
        this.cachingInterval = cachingInterval;
    }

    /**
     * 
     * 
     */
    @JsonProperty("cachingUseCount")
    public Integer getCachingUseCount() {
        return cachingUseCount;
    }

    /**
     * 
     * 
     */
    @JsonProperty("cachingUseCount")
    public void setCachingUseCount(Integer cachingUseCount) {
        this.cachingUseCount = cachingUseCount;
    }

    @JsonProperty("entryType")
    public ListEntryType getEntryType() {
        return entryType;
    }

    @JsonProperty("entryType")
    public void setEntryType(ListEntryType entryType) {
        this.entryType = entryType;
    }

    /**
     * 
     * 
     */
    @JsonProperty("overrides")
    public List<String> getOverrides() {
        return overrides;
    }

    /**
     * 
     * 
     */
    @JsonProperty("overrides")
    public void setOverrides(List<String> overrides) {
        this.overrides = overrides;
    }

    /**
     * 
     * 
     */
    @JsonProperty("providerUrl")
    public String getProviderUrl() {
        return providerUrl;
    }

    /**
     * 
     * 
     */
    @JsonProperty("providerUrl")
    public void setProviderUrl(String providerUrl) {
        this.providerUrl = providerUrl;
    }

    /**
     * 
     * 
     */
    @JsonProperty("refreshInterval")
    public Integer getRefreshInterval() {
        return refreshInterval;
    }

    /**
     * 
     * 
     */
    @JsonProperty("refreshInterval")
    public void setRefreshInterval(Integer refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    /**
     * 
     * 
     */
    @JsonProperty("ttl")
    public Integer getTtl() {
        return ttl;
    }

    /**
     * 
     * 
     */
    @JsonProperty("ttl")
    public void setTtl(Integer ttl) {
        this.ttl = ttl;
    }

}
